package cn.com.duiba.tuia.ssp.center.api.remote.prePayInvoiceRecord.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;

/**
 * 发票明细 DTO
 * @dateTime 2020-12-08 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class InvoiceDetailDto implements Serializable {


    /**
     * 发票图片
     */
    private String pictureUrl;

    /**
     * 发票金额 ( 元 )
     */
    private Long invoiceAmount;

    /**
     * 发票编号
     */
    private String invoiceNumber;

    /**
     * 发票税额
     */
    private Long invoiceTaxAmount;

    /**
     * 不含税金额
     */
    private Long invoiceNotIncludedTaxAmount;

    /**
     * 购买方名称
     */
    private String customerName;

    /**
     * 购买方纳税人识别号
     */
    private String customerNumber;

    /**
     * 销售方名称
     */
    private String sellerName;

    /**
     * 销售方纳税人识别号
     */
    private String sellerNumber;

    /**
     * 开票日期 ( 格式: yyyy-MM-dd )
     */
    private String invoiceDate;

    /**
     * 税率
     */
    private Integer taxRatio;

}