package cn.com.duiba.tuia.ssp.center.api.remote.prePayInvoiceRecord.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;

/**
 * 发票信息 DTO
 * @dateTime 2020-12-08 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class InvoiceInfoDto implements Serializable {


    /**
     * The id.
     */
    protected Long id;

    /**
     * 账户 Id
     */
    private String accountId;

    /**
     * 账户名称
     */
    private String accountName;

    /**
     * 上传时间 ( 格式: yyyy-MM-dd )
     */
    private String uploadDate;

    /**
     * 发票金额 ( 元 )
     */
    private Long invoiceAmount;

    /**
     * 发票编号
     */
    private String invoiceNumber;

    /**
     * 提现/结算·单号
     */
    private String monadNumber;

    /**
     * 发票明细
     */
    private InvoiceDetailDto invoiceDetail;

    /**
     * 审核状态
     * - { 0 : 待审核, 1 : 审核通过, 2 : 审核拒绝 }
     */
    private Integer invoiceCheckStatus;

    /**
     * 审核·拒绝原因
     */
    private String invoiceCheckReason;

    /**
     * 流转状态
     * - { 0 : 媒介助理, 1 : 已提交财务 }
     */
    private Integer circulationStatus;

    /**
     * 流转详情
     */
    private CirculationDetailDto circulationDetail;

}