package cn.com.duiba.tuia.ssp.center.api.remote.prePayInvoiceRecord.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;

/**
 * 发票追踪 DTO
 * @dateTime 2020-12-08 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class InvoiceTrackingDto implements Serializable {


    /**
     * 账户 Id
     */
    private String accountId;

    /**
     * 账户名称
     */
    private String accountName;

    /**
     * 预付款·总额 ( 元 )
     */
    private Long prepaymentTotalMoney;

    /**
     * 消耗·总额 ( 元 )
     */
    private Long consumeTotalMoney;

    /**
     * 已开票·总额 ( 元 )
     */
    private Long invoicedTotalMoney;

    /**
     * 未开票·总额 ( 元 )
     */
    private Long notInvoicedTotalMoney;

}