package cn.com.duiba.tuia.ssp.center.api.remote.prePayInvoiceRecord.params;

import cn.com.duiba.tuia.ssp.center.api.dto.common.BasePage;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * { 获取 } 发票列表 Params
 * @dateTime 2020-12-08 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(fluent = false, chain = true, prefix = "")
public class GainInvoiceParams extends BasePage implements Serializable {


    /**
     * 开票主体
     */
    @ApiModelProperty(value = "开票主体: { 0 : 杭州推啊, 1 : 霍尔果斯, 2 : 霍城兑捷 }", required = false)
    private Integer invoiceBody;

    /**
     * 流转状态
     */
    @ApiModelProperty(value = "流转状态: { 0 : 媒介助理, 1 : 已提交财务 }", required = false)
    private Integer circulationStatus;

    /**
     * 账户名称
     */
    @ApiModelProperty(value = "账户名称", required = false)
    private String accountName;

    /**
     * 账户 Id
     */
    @ApiModelProperty(value = "账户 Id", required = false)
    private String accountId;

    /**
     * 审核状态
     */
    @ApiModelProperty(value = "发票审核状态: { 0 : 待审核, 1 : 审核通过, 2 : 审核拒绝 }", required = false)
    private Integer invoiceCheckStatus;

    /**
     * 发票编号
     */
    @ApiModelProperty(value = "发票编号", required = false)
    private String invoiceNumber;

    /**
     * 提现/结算·单号
     */
    @ApiModelProperty(value = "提现/结算·单号", required = false)
    private String monadNumber;

    /**
     * 开始日期
     */
    @NotNull(message = "开始日期不允许为空.")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "开始日期", required = true)
    private String startDate;

    /**
     * 结束日期
     */
    @NotNull(message = "结束日期不允许为空.")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "结束日期", required = true)
    private String endDate;

}