package cn.com.duiba.tuia.ssp.center.api.remote.prePayInvoiceRecord.params;

import cn.com.duiba.tuia.ssp.center.api.dto.common.BasePage;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * { 获取 } 发票追踪 Params
 * @dateTime 2020-12-08 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(fluent = false, chain = true, prefix = "")
public class GainInvoiceTrackingParams extends BasePage implements Serializable {


    /**
     * 追踪纬度
     */
    @ApiModelProperty(value = "流转状态: { 0 : 预付款维度, 1 : 消耗维度 }", required = false)
    private Integer latitude = 0;

    /**
     * 账户名称
     */
    @ApiModelProperty(value = "账户名称", required = false)
    private String accountName;

    /**
     * 账户 Id
     */
    @ApiModelProperty(value = "账户 Id", required = false)
    private String accountId;

    /**
     * 开始日期
     */
    @NotNull(message = "开始日期不允许为空.")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "开始日期", required = true)
    private String startDate;

    /**
     * 结束日期
     */
    @NotNull(message = "结束日期不允许为空.")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "结束日期", required = true)
    private String endDate;

}