package cn.com.duiba.tuia.ssp.center.api.remote.prePayInvoiceRecord.params;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;

/**
 * { 保存 } 审核结果 Params
 * @dateTime 2020-12-08 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class SavingReviewResultParams implements Serializable {


    /**
     * The id.
     */
    @ApiModelProperty(value = "The id.", required = true)
    private Long id;

    /**
     * 审核状态
     * - { 1 : 审核通过, 2 : 审核拒绝 }
     */
    @ApiModelProperty(value = "流转状态: { 0 : 媒介助理, 1 : 已提交财务 }", required = true)
    private Integer checkStatus;

    /**
     * 审核·拒绝原因
     */
    @ApiModelProperty(value = "审核·拒绝原因", required = false)
    private String checkReason;

}