package cn.com.duiba.tuia.ssp.center.api.dto.media;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 出价比例信息
 * @dateTime 2019-09-26 17:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class MediaAppDto implements Serializable {

    /*
     * 序列化 SerialVersionUId
     */
    private static final long serialVersionUID = 1L;

    /*
     * 应用 Id
     */
    private Long appId;

    /*
     * 出价比例
     */
    private BigDecimal bidRatio;

    /*
     * 出价比例
     */
    private String bidRatioString;

    /**
     * 重写 ToString
     * @return 结果
     */
    @Override
    public String toString() {
        StringBuilder builder;
        builder = new StringBuilder(getClass().getSimpleName());
        builder.append(" [").append("Hash = ").append(hashCode())
                .append(", appId=").append(appId)
                .append(", bidRatio=").append(bidRatio)
                .append(", bidRatioString=").append(bidRatioString)
                .append(", serialVersionUID=").append(serialVersionUID).append("]");
        return builder.toString();
    }

}