package cn.com.duiba.tuia.ssp.center.api.constant.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum ExternalPlatformMediaAccountEnum {

    IQIYI(0, "爱奇艺"),
    KUAI_SHOU(1, "快手"),
    THREE_SIX_ZERO(2,"360"),
    OPPO(3,"oppo"),
    BAIDU(4,"百度"),
    MANGO(5,"芒果"),
    WEIBO(6,"微博"),
    GUAN_DIAN_TONG(7,"广点通"),
    VIVO(8,"vivo")
    ;

    private Integer type;

    private String name;

    public static String getNameByType(Integer type) {
        if (type == null) {
            return null;
        }
        for (ExternalPlatformMediaAccountEnum accountEnum : ExternalPlatformMediaAccountEnum.values()) {
            if (accountEnum.type.equals(type)) {
                return accountEnum.name;
            }
        }
        return null;
    }

}