package cn.com.duiba.tuia.ssp.center.api.remote.media.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

/**
 * 类型枚举
 * 注: 送审 ( 新送审 · 重新送审 ) 类型 ( 广告主 · 广告计划 ).
 * @dateTime 2019-11-06 17:51:27
 * @author haitao.hua
 */
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = true, chain = true, prefix = "")
public enum ReviewTypeEnum {

    /*################################# 送审类型的枚举 ( Start ) #####################################*/

    Advertiser(1, "广告主"),
    AdvertPlan(2, "广告计划");

    /*################################# 送审类型的枚举 ( end ) #######################################*/

    /**
     * 标识码
     */
    @Getter
    private Integer code;

    /**
     * 备注
     */
    @Getter
    private String remark;

    /**
     * Seek 值
     * @param code 标识码
     * @return 结果
     */
    public static ReviewTypeEnum seekValue(Integer code) {
        Optional<ReviewTypeEnum> result = Arrays.stream(ReviewTypeEnum.values()).filter(target -> (Objects.nonNull(target) && target.code.equals(code))).findFirst();
        return result.orElse(null);
    }

}
