package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 媒体接口产品化相关
 */
@AdvancedFeignClient
public interface RemoteCreditsService {

    /**
     * 获取分页list
     * @param id
     * @param title
     * @param creator
     * @param offset
     * @param max
     * @return
     */
    public DubboResult<PageResultDto<CreditsConsumeDto>> getCreditsConsumeList(Long id, String title, String creator, Integer offset, Integer max);

    /**
     * 删除计划
     * @param id
     * @return
     */
    DubboResult<Boolean> delete(Long id);

    /**
     * 修改状态
     * @param id
     * @param status
     * @return
     */
    Integer updateStatus(Long id,Integer status);

    /**
     * 根据id获取详情
     * @param id
     * @return
     */
    CreditsConsumeDetailDto getById(Long id);

    /**
     * 创建积分消耗配置
     * @param dto
     * @return
     */
    Integer create(CreditsConsumeDetailDto dto);

    /**
     * 修改积分消耗配置
     * @param dto
     * @return
     */
    Integer update(CreditsConsumeDetailDto dto);

    /**
     * 预警配置
     * @param dto
     * @return
     */
    Integer updateAlarmInfo(CreditsConsumeDto dto);

    /**
     * 是否存在
     * @param id
     * @return
     */
    DubboResult<Integer> selectCountByParams(Long id);

    /**
     * 获取定向配置详情
     * @param id
     * @return
     */
    OrienteeringReturnDetailDto getOrienteeringDetail(Long id);

    /**
     * 修改定向配置
     * @param dto
     * @return
     */
    DubboResult<List<ErrorResultDto>> updateOrienteering(CreditsOrienteeringDetailDto dto);

    /**
     * 根据关联id查询配置
     * @param releationIds
     * @return
     */
    List<CreditsOrienteerRelationDto> getByReleationIds(List<Long> releationIds);

    CreditsAlarmDto getAlarmInfo(Long id);

}
