package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang3.builder.ToStringBuilder;

import cn.com.duiba.tuia.ssp.center.api.annotation.SensitiveInfo;
import cn.com.duiba.tuia.ssp.center.api.annotation.SensitiveType;

import java.util.List;

/**
 * ClassName: AppStatisticsDataRsp <br/>
 * date: 2016年12月21日 上午11:31:11 <br/>
 * .
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@SensitiveInfo(sensitiveFields = {"account"})
public class AppStatisticsDataRsp extends BaseStatisticsDataRsp {

    /** The Constant serialVersionUID. @since JDK 1.6 */
    private static final long serialVersionUID = 4185789708260616603L;

    /** 媒体ID. */
    private Long              appId;

    /** 媒体名称. */
    private String            appName;

    /** 系统平台. */
    private String            platform;

    /** 日期 */
    private String            curDate;

    /** 用户ID */
    private Long              mediaId;

    /** 用户账号 */
    @SensitiveInfo(sensitiveType = SensitiveType.EMAIL)
    private String            account;

    /** 一级标签 */
    private String            tagName1;
    /** 二级标签 */
    private String            tagName2;
    /** 媒体流量标签 */
    private String            flowTagName;
    /** 分级流量标签 */
    private String            gradeTagName;
    private Long              subMediaId;

    /**
     * 预估得分
     */
    private String estimateScore;

    /**
     * 质量等级
     */
    private String estimateLevel;


    /** 网赚标签ID **/
    private String              emoTagId;
    /** 网赚标签名称 **/
    private String              emoTagName;

    /**
     * 交易方式对应的标签，交易方式支持多选，所以是list类型
     */
    private List<MediaTagDto> tradeTypeTags;
    /**
     * 流量载体对应的标签，流量载体支持多选，所以是list类型
     */
    private List<MediaTagDto> carrierFlowTags;

    /**
     * Gets the app id.
     *
     * @return the app id
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * Sets the app id.
     *
     * @param appId the app id
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * Gets the app name.
     *
     * @return the app name
     */
    public String getAppName() {
        return appName;
    }

    /**
     * Sets the app name.
     *
     * @param appName the app name
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * Gets the platform.
     *
     * @return the platform
     */
    public String getPlatform() {
        return platform;
    }

    /**
     * Sets the platform.
     *
     * @param platform the platform
     */
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    /**
     * Gets the curDate.
     *
     * @return the curDate
     */
    public String getCurDate() {
        return curDate;
    }

    /**
     * Sets the curDate.
     *
     * @param curDate the curDate
     */
    public void setCurDate(String curDate) {
        this.curDate = curDate;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public String getTagName1() {
        return tagName1;
    }

    public void setTagName1(String tagName1) {
        this.tagName1 = tagName1;
    }

    public String getTagName2() {
        return tagName2;
    }

    public void setTagName2(String tagName2) {
        this.tagName2 = tagName2;
    }

    public String getFlowTagName() {
        return flowTagName;
    }

    public void setFlowTagName(String flowTagName) {
        this.flowTagName = flowTagName;
    }

	public String getGradeTagName() {
		return gradeTagName;
	}

	public void setGradeTagName(String gradeTagName) {
		this.gradeTagName = gradeTagName;
	}

    public Long getSubMediaId() {
        return subMediaId;
    }

    public void setSubMediaId(Long subMediaId) {
        this.subMediaId = subMediaId;
    }

    public String getEstimateScore() {
        return estimateScore;
    }

    public void setEstimateScore(String estimateScore) {
        this.estimateScore = estimateScore;
    }

    public String getEstimateLevel() {
        return estimateLevel;
    }

    public void setEstimateLevel(String estimateLevel) {
        this.estimateLevel = estimateLevel;
    }

    public String getEmoTagId() {
        return emoTagId;
    }

    public void setEmoTagId(String emoTagId) {
        this.emoTagId = emoTagId;
    }

    public String getEmoTagName() {
        return emoTagName;
    }

    public void setEmoTagName(String emoTagName) {
        this.emoTagName = emoTagName;
    }

    public List<MediaTagDto> getTradeTypeTags() {
        return tradeTypeTags;
    }

    public void setTradeTypeTags(List<MediaTagDto> tradeTypeTags) {
        this.tradeTypeTags = tradeTypeTags;
    }

    public List<MediaTagDto> getCarrierFlowTags() {
        return carrierFlowTags;
    }

    public void setCarrierFlowTags(List<MediaTagDto> carrierFlowTags) {
        this.carrierFlowTags = carrierFlowTags;
    }
}
