package cn.com.duiba.tuia.ssp.center.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author yuquanfeng
 * @Date 2021/6/2
 * @Description
 * @Param
 * @return
 **/
@Data
public class ReqSendMessageDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 邮件标题 标题不能超过10个字符 必填
     */
    @ApiModelProperty(value = "邮件标题", required = true)
    @NotNull(message = "消息标题不能为空")
    @Length(min = 1, max = 10)
    private String title;
    /**
     * 内容 必填
     */
    @ApiModelProperty(value = "内容", required = true)
    @NotNull(message = "消息内容不能为空")
    private String content;
    /**
     * 收件人列表 必填
     */
    @NotNull(message = "收件人不能为空")
    @ApiModelProperty(value = "收件人列表", required = true)
    private List<Long> receiverList;
    /**
     * 发件人id 选填(但发件人或者发件人id必须有一个有值）
     */
    @ApiModelProperty(value = "发件人id")
    private Long senderId;
    /**
     * 发送人   选填(但发件人或者发件人id必须有一个有值）
     */
    @ApiModelProperty(value = "发送人")
    private String sender;
    /**
     * 自定义按钮名称 非必填
     */
    @ApiModelProperty(value = "自定义按钮名称")
    private String buttonName;
    /**
     * 需要跳转的链接 非必填
     */
    @ApiModelProperty(value = "需要跳转的链接")
    private String url;
    /**
     * 消息类型:1-媒体线通知;2-火眼数据通知;3-广告线通知;4-实验平台通知;5-分控通知;6-其他 必填
     */
    @NotNull(message = "消息类型不能为空")
    @ApiModelProperty(value = "消息类型", required = true)
    private Integer messageType;
    /**
     * 发送类型 0-即时发送 1-定时发送 非必填-不传默认为0
     */
    @ApiModelProperty(value = "发送类型")
    private Integer sendType;
    /**
     * 发送时间 非必填
     * sendType==0 时不用传
     * sendType==1 时传 不传默认 new Date()
     */
    @ApiModelProperty(value = "发送时间")
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date sendTime;
}
