package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.externalplatformmedia.ExternalPlatformMediaAccountDTO;
import java.util.List;

@AdvancedFeignClient
public interface RemoteExternalPlatformMediaAccountService {

    boolean entryAccount(ExternalPlatformMediaAccountDTO externalPlatformMediaAccountDTO);

    boolean editAccount(ExternalPlatformMediaAccountDTO externalPlatformMediaAccountDTO);

    boolean editAccountRebates(ExternalPlatformMediaAccountDTO externalPlatformMediaAccountDTO);

    boolean deleteAccount(Long id);

    ExternalPlatformMediaAccountDTO getMediaAccountDetail(Long id);

    List<ExternalPlatformMediaAccountDTO> selectListExceptItself(ExternalPlatformMediaAccountDTO externalPlatformMediaAccountDTO);

    List<ExternalPlatformMediaAccountDTO> selectListByCondition(ExternalPlatformMediaAccountDTO externalPlatformMediaAccountDTO);


    /**
     * 同步媒体 Cookies
     * @param accountId 账户 Id
     * @param childrenId 子账户 Id
     * @param cookies Cookies
     * @return 处理结果
     */
    boolean syncsCookies(String accountId, String childrenId, String cookies);

}
