package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.NoticeGroupByMessageTypeDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.NoticeMediaDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqNoticeMediaDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqSendMessageDTO;

import java.util.List;
import java.util.concurrent.TimeUnit;


/**
 * @Author yuquanfeng
 * @Date 2021/6/1
 * @Description
 * @Param
 * @return
 **/
@AdvancedFeignClient
public interface RemoteManagerMessageService {

/**************************************************************************************发送消息到ssp-manager后台相关API***********************************************************************/
    /**
     * 发送即时消息
     * @param reqSendMessageDTO 发送消息内容
     * @return
     * @throws BizException
     */
    Boolean sendMessageToSspManagerNoDelay(ReqSendMessageDTO reqSendMessageDTO) throws BizException;

    /**
     * 发送延时消息
     * @param reqSendMessageDTO 消息内容
     * @param delayTime 延迟时间
     *                  当延迟时间为空时 等同于即时消息
     * @param timeUnit 延迟时间单位
     *                 延迟时间单位为空时 默认为 分钟(TimeUnit.SECONDS）
     * @return
     * @throws BizException
     */
    Boolean sendMessageToSspManagerWithDelay(ReqSendMessageDTO reqSendMessageDTO, Long delayTime, TimeUnit timeUnit) throws BizException;

    /**
     * 发送消息 包含即时发送和延时发送两种，即时发送传sendType-0 定时发送sendType-1
     * 当sendType==0 时 sendTime不需要传，传了也不用你的
     * 当sendType==1 时 sendTime指定需要发送的具体时间，否则和即时发送无区别
     * @param reqSendMessageDTO
     * @return
     * @throws BizException
     */
    Boolean sendMessageToSspManager(ReqSendMessageDTO reqSendMessageDTO) throws BizException;

/*****************************************************************************************************************************************************************************************/
    /**
     * 根据条件查询，支持条件查询
     * @param reqNoticeMediaDTO 查询条件
     * @return List<NoticeDto>
     * @throws BizException
     */
    List<NoticeMediaDto> getNoticeByCondition(ReqNoticeMediaDTO reqNoticeMediaDTO) throws BizException;

    /**
     * 查询条数
     * @param reqNoticeMediaDTO 查询条件
     * @return Integer
     * @throws BizException
     */
    Integer getCount(ReqNoticeMediaDTO reqNoticeMediaDTO) throws BizException;

    /**
     * 批量更新消息状态
     * @param noticeMediaDto 更新参数
     * @return
     * @throws BizException
     */
    Integer batchUpdateNoticeMediaByIdOrIds(NoticeMediaDto noticeMediaDto) throws BizException;

    /**
     * 根据条件查询消息条数 通过messageType分组
     * @param reqNoticeMediaDTO
     * @return
     */
    List<NoticeGroupByMessageTypeDTO> getCountGroupByMessageType(ReqNoticeMediaDTO reqNoticeMediaDTO);

    /**
     * 批量插入
     * @param noticeMediaDtos
     * @return
     */
    Integer batchInsertIntoNoticeMedia(List<NoticeMediaDto> noticeMediaDtos);

}
