package cn.com.duiba.tuia.ssp.center.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * 通知（站内信）DTO
 *
 * @author songjiaxing
 *
 */
@ApiModel
public class NoticeDto extends BaseDto {

	private static final long serialVersionUID = 8712355321169783096L;

	/**
	 * 消息立即发送
	 */
	public static final int SENT_TYPE_DIRECT = 0;

	/**
	 * 消息定时发送
	 */
	public static final int SENT_TYPE_TIME = 1;

	/**
	 * 定向方式-全部媒体
	 */
	public static final int DIRECT_TYPE_ALL = 0;

	/**
	 * 定向方式-定向媒体
	 */
	public static final int DIRECT_TYPE_PART = 1;

	/**
	 * 系统通知
	 */
	public static final int NOTICE_TYPE_SYS = 1;

	/**
	 * 推啊news
	 */
	public static final int NOTICE_TYPE_NEWS = 2;
	/**
	 * tb_notice_media表主键
	 */
	private Long noticeMediaId;

	/**
	 * 通知主题
	 */
	@ApiModelProperty(value = "通知标题",required=true)
	@NotNull(message="通知主题不能为空")
	private String title;

	/**
	 * 发件团队
	 */
	@ApiModelProperty(value = "发件团队",required=true)
	@NotNull(message="发件团队不能为空")
	private String sender;

	/**
	 * 定向方式（0：全部，1：定向媒体）
	 */
	@ApiModelProperty(value = "定向方式（0：全部，1：定向媒体）",required=true)
	@NotNull(message="定向方式不能为空")
	private Integer directType;

	/**
	 * 发送类型（0：立即发送，1：定时发送）
	 */
	@ApiModelProperty(value = "发送类型（0：立即发送，1：定时发送）",required=true)
	@NotNull(message="发送类型不能为空")
	private Integer sendType;

	/**
	 * 发送时间
	 */
	@ApiModelProperty(value = "发送时间")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
	private Date sendTime;

	/**
	 * 送达状态：（0：未送达，1：已送达）
	 */
	@ApiModelProperty(value = "送达状态：（0：未送达，1：已送达）")
	private Integer sendStatus;

	/**
	 * 通知内容
	 */
	@ApiModelProperty(value = "通知内容",required=true)
	private String content;

	/**
	 * 收件人(mediaId以‘,’隔开)
	 */
	@ApiModelProperty(value = "收件人(mediaId以‘,’隔开)")
	private String receiver;

	/**
	 * 扩展字段，通知类型（1：系统通知 2：推啊news通知）
	 */
	private Integer noticeType;

	/**
	 * 是否删除 1：已删除 0：未删除
	 */
	private Integer isDelete;

	/**
	 * 读取状态（0：接收未读，1：接收已读）
	 */
	@ApiModelProperty(value = "读取状态（0：接收未读，1：接收已读）")
	private Integer readStatus;

	@ApiModelProperty(value = "收件媒体列表")
	private List<NoticeAccountDto> noticeAccountDtos;

	@ApiModelProperty(value = "下一条通知")
	private NoticeDto nextNotice;

	@ApiModelProperty(value = "news类型（0：推啊头条，1：推啊玩法，2：推啊季刊）")
	private Integer newsType;

	@ApiModelProperty(value = "封面url")
	private String coverUrl;

	@ApiModelProperty(value = "简介")
	private String introduction;

	@ApiModelProperty(value = "文章点击数")
	private Long readPv;

	/**
	 * 已阅读数量
	 */
	@ApiModelProperty(value = "已阅读数量")
	private Integer readNum;

	/**
	 * 外链设置
	 */
	@ApiModelProperty(value = "外链设置： 0-否，1-是")
	private  Integer siteOuterChain;

	/**
	 * 外链链接
	 */
	@ApiModelProperty(value = "外链链接")
	private String outerChainUrl;

	/**
	 * 模板类型
	 */
	@ApiModelProperty(value = "模板类型")
	private String templateCode;

	/**
	 * 是否弹层 0-不弹 1-弹
	 */
	@ApiModelProperty(value = "是否弹层 0-不弹 1-弹")
	private Integer isPop;

	/**
	 * 消息类型:1-媒体线通知;2-火眼数据通知;3-广告线通知;4-实验平台通知;5-分控通知;6-其他
	 */
	private Integer messageType;
	/**
	 * 平台:1-媒体后台;2-媒体管理后台
	 */
	private Integer platform;
	/**
	 * 按钮名称
	 */
	private String buttonName;

	public String getButtonName() {
		return buttonName;
	}

	public void setButtonName(String buttonName) {
		this.buttonName = buttonName;
	}

	public Integer getMessageType() {
		return messageType;
	}

	public void setMessageType(Integer messageType) {
		this.messageType = messageType;
	}

	public Integer getPlatform() {
		return platform;
	}

	public void setPlatform(Integer platform) {
		this.platform = platform;
	}

	public Integer getNewsType() {
		return newsType;
	}

	public void setNewsType(Integer newsType) {
		this.newsType = newsType;
	}

	public String getCoverUrl() {
		return coverUrl;
	}

	public void setCoverUrl(String coverUrl) {
		this.coverUrl = coverUrl;
	}

	public String getIntroduction() {
		return introduction;
	}

	public void setIntroduction(String introduction) {
		this.introduction = introduction;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getSender() {
		return sender;
	}

	public void setSender(String sender) {
		this.sender = sender;
	}

	public Integer getDirectType() {
		return directType;
	}

	public void setDirectType(Integer directType) {
		this.directType = directType;
	}

	public Date getSendTime() {
		return sendTime;
	}

	public void setSendTime(Date sendTime) {
		this.sendTime = sendTime;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getReceiver() {
		return receiver;
	}

	public void setReceiver(String receiver) {
		this.receiver = receiver;
	}

	public Integer getNoticeType() {
		return noticeType;
	}

	public void setNoticeType(Integer noticeType) {
		this.noticeType = noticeType;
	}

	public Integer getIsDelete() {
		return isDelete;
	}

	public void setIsDelete(Integer isDelete) {
		this.isDelete = isDelete;
	}

	public Integer getReadStatus() {
		return readStatus;
	}

	public void setReadStatus(Integer readStatus) {
		this.readStatus = readStatus;
	}

	public Integer getSendType() {
		return sendType;
	}

	public void setSendType(Integer sendType) {
		this.sendType = sendType;
	}

	public List<NoticeAccountDto> getNoticeAccountDtos() {
		return noticeAccountDtos;
	}

	public void setNoticeAccountDtos(List<NoticeAccountDto> noticeAccountDtos) {
		this.noticeAccountDtos = noticeAccountDtos;
	}

	public Integer getSendStatus() {
		return sendStatus;
	}

	public void setSendStatus(Integer sendStatus) {
		this.sendStatus = sendStatus;
	}

	public NoticeDto getNextNotice() {
		return nextNotice;
	}

	public void setNextNotice(NoticeDto nextNotice) {
		this.nextNotice = nextNotice;
	}

	public Integer getReadNum() {
		return readNum;
	}

	public void setReadNum(Integer readNum) {
		this.readNum = readNum;
	}

	public Long getReadPv() {
		return readPv;
	}

	public void setReadPv(Long readPv) {
		this.readPv = readPv;
	}

	public Integer getSiteOuterChain() {
		return siteOuterChain;
	}

	public void setSiteOuterChain(Integer siteOuterChain) {
		this.siteOuterChain = siteOuterChain;
	}

	public String getOuterChainUrl() {
		return outerChainUrl;
	}

	public void setOuterChainUrl(String outerChainUrl) {
		this.outerChainUrl = outerChainUrl;
	}

	public String getTemplateCode() {
		return templateCode;
	}

	public void setTemplateCode(String templateCode) {
		this.templateCode = templateCode;
	}

	public Integer getIsPop() {
		return isPop;
	}

	public void setIsPop(Integer isPop) {
		this.isPop = isPop;
	}
}
