package cn.com.duiba.tuia.ssp.center.api.remote.advertselect.remoteservice.media;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.remote.advertselect.dto.media.req.AuditAdvertReq;
import cn.com.duiba.tuia.ssp.center.api.remote.advertselect.dto.media.req.BaseAdvertReq;
import cn.com.duiba.tuia.ssp.center.api.remote.advertselect.dto.media.req.BuzTagAdvertInfoReq;
import cn.com.duiba.tuia.ssp.center.api.remote.advertselect.dto.media.rsp.AdvertAuditRsp;
import cn.com.duiba.tuia.ssp.center.api.remote.advertselect.dto.media.rsp.AdvertSelectRsp;
import cn.com.duiba.tuia.ssp.center.api.remote.advertselect.dto.media.rsp.BuzTagAdvertsPageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;

/**
 * 〈一句话功能简述〉<br>
 * Description: 查询广告信息接口
 *
 * @author hillchen
 * @create 2018/10/24 16:16
 */

@AdvancedFeignClient
public interface RemoteFindAdvertService {

    /**
     * 查询屏蔽策略的指定标签下广告信息列表
     * @return
     */
    BuzTagAdvertsPageResultDto findAdvertInfoByBuzTag(BuzTagAdvertInfoReq buzTagAdvertInfoReq);
    /**
     * 分页查询广告位屏蔽策略下的待审核广告列表
     * @param auditAdvertReq
     * @return
     */
    PageResultDto<AdvertAuditRsp> findStrategyAuditAdverts(AuditAdvertReq auditAdvertReq);

    /**
     * 分页查询广告位屏蔽策略下的选中广告列表
     * @param baseAdvertReq
     * @return
     */
    PageResultDto<AdvertSelectRsp> findStrategySelectedAdverts(BaseAdvertReq baseAdvertReq);


}