package cn.com.duiba.tuia.ssp.center.api.query;

import cn.com.duiba.tuia.ssp.center.api.constant.enums.FileCollectShieldStatusEnum;
import cn.com.duiba.tuia.ssp.center.api.dto.BaseQueryDto;
import lombok.Data;
import lombok.ToString;

import java.util.Date;

/**
 * 文件收集屏蔽配置查询实体类
 * @author K. L. Mao
 * @create 2019-12-09
 */
@Data
@ToString(callSuper = true)
public class FileCollectShieldConfigQuery extends BaseQueryDto {

    private Long id;

    /**
     * 手机品牌
     */
    private String phoneBrand;

    /**
     * 手机型号
     */
    private String phoneType;

    /**
     * 屏蔽状态：1：屏蔽中；9：其他
     *
     * {@link FileCollectShieldStatusEnum}
     */
    private Integer status;

    /**
     * 是否删除 0：未删除；1：已删除
     */
    private Boolean isDelete;

    /**
     * 创建起始时间
     */
    private Date gmtCreateFrom;

    /**
     * 创建结束时间
     */
    private Date gmtCreateTo;

    /**
     * 修改起始时间
     */
    private Date gmtModifiedFrom;

    /**
     * 修改结束时间
     */
    private Date gmtModifiedTo;
}
