package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotDailyTheoryConsumeDTO;

import java.util.Date;
import java.util.List;

/**
 * @Author yuquanfeng
 * @Date 2021/6/10
 * @Description
 * @Param
 * @return
 **/
@AdvancedFeignClient
public interface RemoteSlotDailyTheoryConsumeService {
    /**
     * 多条件查询
     * @param slotDailyTheoryConsumeDTO 查询条件
     * @return
     */
    List<SlotDailyTheoryConsumeDTO> selectSlotDailyTheoryConsume(SlotDailyTheoryConsumeDTO slotDailyTheoryConsumeDTO);

    /**
     * 分页查询
     * @param slotDailyTheoryConsumeDTO 查询条件 需带上分页信息
     * @return
     */
    PageResultDto<SlotDailyTheoryConsumeDTO> selectSlotDailyTheoryConsumeByPage(SlotDailyTheoryConsumeDTO slotDailyTheoryConsumeDTO);

    /**
     * 查询每个广告位的理论消耗总和根据slotId分组
     * @param slotDailyTheoryConsumeDTO 查询条件
     * @return
     */
    List<SlotDailyTheoryConsumeDTO> selectSumTheoryConsumeGroupBySlot(SlotDailyTheoryConsumeDTO slotDailyTheoryConsumeDTO);

    /**
     * 通过appId分组查询
     * @param appIds appId列表
     * @param startDate 开始时间
     * @param endDate 结束时间
     * @return
     */
    List<SlotDailyTheoryConsumeDTO> selectSumTheoryConsumeGroupByAppId(List<Long> appIds, Date startDate, Date endDate);
}
