package cn.com.duiba.tuia.ssp.center.api.tool;

import java.math.BigDecimal;
import java.util.Objects;


/**
 * @Author yuquanfeng
 * @Date 2021/6/11
 * @Description 计算预计昨日媒体收入工具类
 * @Param
 * @return
 **/
public class CalculateYesterdayExpectMediaIncomeUtil {

    /** 计费方式分成 */
    public static final int CHARGE_TYPE_DIVIDED_INTO = 0;
    /** 计费方式CPC */
    public static final int CHARGE_TYPE_CPC          = 1;
    /** 计费方式CPM */
    public static final int CHARGE_TYPE_CPM          = 2;
    /** UV单价 */
    public static final int CHARGE_TYPE_UV           = 3;
    /** 每日计费 */
    public static final int CHARGE_TYPE_CPT          = 4;
    /** PV单价 */
    public static final int CHARGE_TYPE_PV          = 5;

    /**
     * @param price 价格（分）
     * @param chargeType 计费方式:0-分成;1-CPC;2-CPM,3-UV单价
     * @param mediaSplitRatio 媒体分账比例：%
     * @param yesterdayCashConsume 昨日现金总消耗
     * @param validActClick 广告位有效点击PV
     * @param validActExpose 广告位有效曝光PV
     * @param slotRequestUv 广告位曝光UV
     * @param slotEfRequestPvCount 广告位有效访问PV
     * @return 预计昨日媒体收入
     */
    public static BigDecimal calculateYesterdayExpectMediaIncomeUtil(Integer chargeType, Integer mediaSplitRatio, Long yesterdayCashConsume, Integer price,
                                                                     Long validActClick, Long validActExpose, Long slotRequestUv, Long slotEfRequestPvCount){

        if(Objects.isNull(mediaSplitRatio)){
            mediaSplitRatio = 0;
        }
        if(Objects.isNull(yesterdayCashConsume)){
            yesterdayCashConsume = 0L;
        }
        if(Objects.isNull(price)){
            price = 0;
        }
        if(Objects.isNull(validActClick)){
            validActClick = 0L;
        }
        if(Objects.isNull(validActExpose)){
            validActExpose = 0L;
        }
        if(Objects.isNull(slotRequestUv)){
            slotRequestUv = 0L;
        }
        if(Objects.isNull(slotEfRequestPvCount)){
            slotEfRequestPvCount = 0L;
        }
        BigDecimal result = new BigDecimal(0).setScale(3, BigDecimal.ROUND_HALF_UP);
        if(chargeType == null){
            return result;
        }
        switch (chargeType){
            //计费方式为分成时
            case CHARGE_TYPE_DIVIDED_INTO:
                //计算公式：mediaSplitRatio(媒体分账比例) * yesterdayCashConsume(昨日现金消耗)/10000 保留2位小数
                result = new BigDecimal(mediaSplitRatio).multiply(new BigDecimal(yesterdayCashConsume)).
                        divide(new BigDecimal(10000), 2, BigDecimal.ROUND_HALF_UP);
            //计费方式为CPC时
            case CHARGE_TYPE_CPC:
                //计算方式：price(价格) * validActClick(广告位有效点击PV) /10 保留3位小数
                result = new BigDecimal(price).multiply(new BigDecimal(validActClick)).
                        divide(new BigDecimal(10), 3, BigDecimal.ROUND_HALF_UP);
            //计费方式为CPM时
            case CHARGE_TYPE_CPM:
                //计算方式：price(价格) * validActExpose(广告位有效曝光PV) /1000 保留2位小数
                result =  new BigDecimal(price).multiply(new BigDecimal(validActExpose)).
                        divide(new BigDecimal(1000), 2, BigDecimal.ROUND_HALF_UP);
            //计费方式为UV时
            case CHARGE_TYPE_UV:
                //计算方式：price(价格) * slotRequestUv(广告位曝光UV) /10 保留3位小数
                result = new BigDecimal(price).multiply(new BigDecimal(slotRequestUv)).
                        divide(new BigDecimal(10), 3, BigDecimal.ROUND_HALF_UP);
            //计费方式为CPT时
            case CHARGE_TYPE_CPT:
                //计算方式：price(价格) 保留2位小数
                result =  new BigDecimal(price).setScale(2, BigDecimal.ROUND_HALF_UP);
            //计费方式为PV时
            case CHARGE_TYPE_PV:
                //计算方式：price(价格) * slotEfRequestPvCount(广告位有效访问PV) /10 保留3位小数
                result =  new BigDecimal(price).multiply(new BigDecimal(slotEfRequestPvCount)).
                        divide(new BigDecimal(10), 3, BigDecimal.ROUND_HALF_UP);
        }
        return result;
    }
}
