/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.econtract.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Date;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;

public class RSAUtils {
    public static String getRtick() {
        long timestamp = new Date().getTime();
        int rnd = (int)Math.random() * 1000;
        String rtick = timestamp + "" + rnd;
        return rtick;
    }

    public static String calcRsaSignNoEncode(String developerId, String privateKey, String host, String methodName, String rtick, String urlParams, String requestBody) {
        return RSAUtils.calcRsaSign(developerId, privateKey, host, methodName, rtick, urlParams, requestBody, false);
    }

    public static String calcRsaSignNeedEncode(String developerId, String privateKey, String host, String methodName, String rtick, String urlParams, String requestBody) {
        return RSAUtils.calcRsaSign(developerId, privateKey, host, methodName, rtick, urlParams, requestBody, true);
    }

    public static String calcRsaSign(String developerId, String privateKey, String host, String methodName, String rtick, String urlParams, String requestBody, boolean needEncode) {
        String requestPath;
        String url = host + methodName;
        TreeMap<String, String> mySignedURLParams = new TreeMap<String, String>();
        mySignedURLParams.put("developerId", developerId);
        mySignedURLParams.put("rtick", rtick);
        mySignedURLParams.put("signType", "rsa");
        if (urlParams != null && !"".equals(urlParams)) {
            String[] params;
            for (String p1 : params = urlParams.split("&")) {
                String[] p2 = p1.split("=");
                String key = p2[0];
                String value = "";
                if (p2.length == 2) {
                    value = p2[1];
                }
                mySignedURLParams.put(key, value);
            }
        }
        try {
            requestPath = new URL(url).getPath();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        StringBuilder signStringBuilder = new StringBuilder();
        for (String name : mySignedURLParams.keySet()) {
            String value = (String)mySignedURLParams.get(name);
            signStringBuilder.append(name);
            signStringBuilder.append("=");
            signStringBuilder.append(value);
        }
        signStringBuilder.append(requestPath);
        if (requestBody != null && !"".equals(requestBody)) {
            String requestMd5 = RSAUtils.getRequestMd5(requestBody);
            signStringBuilder.append(requestMd5);
        }
        String signString = signStringBuilder.toString();
        String rsaSign = RSAUtils.calcRsaSign(privateKey, signString);
        if (needEncode) {
            try {
                rsaSign = URLEncoder.encode(rsaSign, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                rsaSign = null;
            }
        }
        return rsaSign;
    }

    public static String getRequestMd5(String requestBody) {
        String newRequestBody = RSAUtils.convertToUtf8(requestBody);
        byte[] data = newRequestBody.getBytes(StandardCharsets.UTF_8);
        return RSAUtils.md5(data);
    }

    private static String calcRsaSign(String privateKey, String signData) {
        Signature signature;
        PrivateKey priKey;
        KeyFactory keyFactory;
        byte[] data = signData.getBytes(StandardCharsets.UTF_8);
        byte[] sign = null;
        byte[] privateKeyBytes = RSAUtils.base64decode(privateKey.getBytes());
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        try {
            keyFactory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            priKey = keyFactory.generatePrivate(pkcs8KeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            signature = Signature.getInstance("SHA1withRSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            signature.initSign(priKey);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            signature.update(data);
            sign = signature.sign();
        }
        catch (SignatureException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return new String(RSAUtils.base64encode(sign));
    }

    private static String convertToUtf8(String src) {
        if (src == null || src.length() == 0) {
            return src;
        }
        if ("UTF-8".equalsIgnoreCase(Charset.defaultCharset().name())) {
            return src;
        }
        byte[] srcData = src.getBytes();
        return new String(srcData, StandardCharsets.UTF_8);
    }

    public static String md5(byte[] data) {
        MessageDigest mdInst;
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        byte[] btInput = data;
        try {
            mdInst = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        mdInst.update(btInput);
        byte[] md = mdInst.digest();
        int j = md.length;
        char[] str = new char[j * 2];
        int k = 0;
        for (int i = 0; i < j; ++i) {
            byte byte0 = md[i];
            str[k++] = hexDigits[byte0 >>> 4 & 0xF];
            str[k++] = hexDigits[byte0 & 0xF];
        }
        return new String(str);
    }

    public static byte[] base64encode(byte[] data) {
        return Base64.encodeBase64((byte[])data);
    }

    public static String base64encodeString(byte[] data) {
        String base64Str = Base64.encodeBase64String((byte[])data);
        base64Str = RSAUtils.replaceBlank(base64Str);
        return base64Str;
    }

    public static byte[] base64decode(byte[] data) {
        try {
            return Base64.decodeBase64((byte[])data);
        }
        catch (Exception e) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            for (int i = 0; i < data.length; ++i) {
                byte c = data[i];
                if (c == 13 || c == 10) continue;
                outputStream.write(c);
            }
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            data = outputStream.toByteArray();
            return Base64.decodeBase64((byte[])data);
        }
    }

    public static String replaceBlank(String str) {
        String dest = "";
        if (!RSAUtils.isBlank(str)) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static boolean isBlank(String value) {
        return value == null || value.trim().length() < 1;
    }
}

