package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.tuia.ssp.center.api.dto.PageDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ShareProportionAuditDTO;

import java.util.List;

/**
 * @Author yuquanfeng
 * @Date 2021/8/4
 * @Description
 * @Param
 * @return
 **/
public interface RemoteShareProportionAudiService {
    /**
     * 添加分成比例审核记录
     * @param shareProportionAuditDTO 分成比例信息
     * @return
     * @throws BizException
     */
    Boolean addShareProportionAudit(ShareProportionAuditDTO shareProportionAuditDTO) throws BizException;

    /**
     * 通过条件查询
     * @param shareProportionAuditDTO
     * @return
     * @throws BizException
     */
    List<ShareProportionAuditDTO> queryShareProportionAudit(ShareProportionAuditDTO shareProportionAuditDTO) throws BizException;

    /**
     * 分页查询
     * @param shareProportionAuditDTO
     * @return
     * @throws BizException
     */
    PageDto<ShareProportionAuditDTO> pageGetShareProportionAudit(ShareProportionAuditDTO shareProportionAuditDTO) throws BizException;

    /**
     * 批量审核
     * @param idList 审核记录id
     * @param auditStatus 审核状态
     * @return
     * @throws BizException
     */
    Boolean batchAudit(List<Long> idList, Integer auditStatus) throws BizException;
}
