/**
 * Project Name:ssp-center-api File Name:ReqUpdateSlotStatusDto.java Package Name:cn.com.duiba.tuia.ssp.center.api.dto
 * Date:2017年8月30日下午3:20:13 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;

import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName:ReqUpdateSlotStatusDto <br/>
 * Function: 修改广告位状态 <br/>
 * Date: 2017年8月30日 下午3:20:13 <br/>
 * 
 * @author guyan
 * @version
 * @sin@SuppressWarnings("serial") ce JDK 1.6
 * @see
 */
public class ReqUpdateSlotStatusDto implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = 2832695287786474530L;

    /** 广告位Id */
    @ApiModelProperty(value = "广告位Id", required = true)
    @NotNull(message = "广告位Id不能为空")
    private Long              slotId;

    /** 广告位冻结状态 */
    @ApiModelProperty(value = "广告位冻结状态", required = true)
    @NotNull(message = "广告位冻结状态不能为空")
    private Integer           isFrozen;
    
    /**广告位冻结原因*/
    @ApiModelProperty(value = "广告位冻结原因", required = true)
    private String            frozenReason;

    /**
     * 测试计划ID
     */
    private Long              planId;

    
    public String getFrozenReason() {
        return frozenReason;
    }

    
    public void setFrozenReason(String frozenReason) {
        this.frozenReason = frozenReason;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Integer getIsFrozen() {
        return isFrozen;
    }

    public void setIsFrozen(Integer isFrozen) {
        this.isFrozen = isFrozen;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
