package cn.com.duiba.tuia.ssp.center.api.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 媒体结算审核状态
 */
@AllArgsConstructor
@Getter
public enum MediaSettlementCheckStatusEnum {

    CHECK_STATUS_REFUSED(0, "驳回"),

    CHECK_STATUS_WAITING(1, "待财务审核"),

    CHECK_STATUS_PASSED(2, "审核通过");

    private Integer type;

    private String desc;

    public static String getDesc(Integer type) {
        for(MediaSettlementCheckStatusEnum settlement : MediaSettlementCheckStatusEnum.values()) {
            if(Objects.equals(settlement.getType(), type)) {
                return settlement.getDesc();
            }
        }
        return null;
    }
}
