/**
 * Project Name:media-manager-biz File Name:BaseAccountMonthReportRsp.java Package
 * Name:cn.com.duiba.tuia.media.manager.model.rsp Date:2016年12月6日下午8:39:09 Copyright (c) 2016, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import cn.com.duiba.tuia.ssp.center.api.annotation.SensitiveInfo;
import cn.com.duiba.tuia.ssp.center.api.annotation.SensitiveType;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * ClassName:BaseAccountMonthReportRsp <br/>
 * Function: 月账单报表基础Dto. <br/>
 * Date: 2016年12月6日 下午8:39:09 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@SensitiveInfo(sensitiveFields = {"account"})
public class BaseAccountMonthReportRsp implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = -7827162883287182658L;

    /** 月报表Id */
    private Long              id;

    /** 媒体appId */
    private Long              appId;

    /** 媒体用户Id */
    private Long              mediaId;

    /** 媒体app名称 */
    private String            appName;

    /** 账户 */
    @SensitiveInfo(sensitiveType = SensitiveType.EMAIL)
    private String            account;

    /** 所属系统平台 */
    private String            osType;

    /** 广告消耗 */
    private Long              advertConsume;

    /** 媒体预计分成 */
    private Long              preShare;

    /** 媒体应得分成 */
    private Long              justlyShare;

    /** 备注 */
    private String            note;

    /** 公司名称 */
    private String            companyName;

    /** 账户类型 */
    private Integer          roleType;

    /** 管理员名称*/
    private List<String>     managerNameList;

    /**
     * 广告增值消耗（分）
     */
    private Long valueAddedConsume;

    private Date curDate;

    public Long getValueAddedConsume() {
        return valueAddedConsume;
    }

    public void setValueAddedConsume(final Long valueAddedConsume) {
        this.valueAddedConsume = valueAddedConsume;
    }

    /**
     * appId.
     *
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * appName.
     *
     * @return the appName
     * @since JDK 1.6
     */
    public String getAppName() {
        return appName;
    }

    /**
     * appName.
     *
     * @param appName the appName to set
     * @since JDK 1.6
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * account.
     *
     * @return the account
     * @since JDK 1.6
     */
    public String getAccount() {
        return account;
    }

    /**
     * account.
     *
     * @param account the account to set
     * @since JDK 1.6
     */
    public void setAccount(String account) {
        this.account = account;
    }

    /**
     * osType.
     *
     * @return the osType
     * @since JDK 1.6
     */
    public String getOsType() {
        return osType;
    }

    /**
     * osType.
     *
     * @param osType the osType to set
     * @since JDK 1.6
     */
    public void setOsType(String osType) {
        this.osType = osType;
    }

    /**
     * advertConsume.
     *
     * @return the advertConsume
     * @since JDK 1.6
     */
    public Long getAdvertConsume() {
        return advertConsume;
    }

    /**
     * advertConsume.
     *
     * @param advertConsume the advertConsume to set
     * @since JDK 1.6
     */
    public void setAdvertConsume(Long advertConsume) {
        this.advertConsume = advertConsume;
    }

    /**
     * preShare.
     *
     * @return the preShare
     * @since JDK 1.6
     */
    public Long getPreShare() {
        return preShare;
    }

    /**
     * preShare.
     *
     * @param preShare the preShare to set
     * @since JDK 1.6
     */
    public void setPreShare(Long preShare) {
        this.preShare = preShare;
    }

    /**
     * justlyShare.
     *
     * @return the justlyShare
     * @since JDK 1.6
     */
    public Long getJustlyShare() {
        return justlyShare;
    }

    /**
     * justlyShare.
     *
     * @param justlyShare the justlyShare to set
     * @since JDK 1.6
     */
    public void setJustlyShare(Long justlyShare) {
        this.justlyShare = justlyShare;
    }

    /**
     * note.
     *
     * @return the note
     * @since JDK 1.6
     */
    public String getNote() {
        return note;
    }

    /**
     * note.
     *
     * @param note the note to set
     * @since JDK 1.6
     */
    public void setNote(String note) {
        this.note = note;
    }

    /**
     * mediaId.
     *
     * @return the mediaId
     * @since JDK 1.6
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * mediaId.
     *
     * @param mediaId the mediaId to set
     * @since JDK 1.6
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    /**
     * id.
     *
     * @return the id
     * @since JDK 1.6
     */
    public Long getId() {
        return id;
    }

    /**
     * id.
     *
     * @param id the id to set
     * @since JDK 1.6
     */
    public void setId(Long id) {
        this.id = id;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Integer getRoleType() {
        return roleType;
    }

    public void setRoleType(Integer roleType) {
        this.roleType = roleType;
    }

    public List<String> getManagerNameList() {
        return managerNameList;
    }

    public void setManagerNameList(List<String> managerNameList) {
        this.managerNameList = managerNameList;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);

    }

}
