package cn.com.duiba.tuia.ssp.center.api.dto.externalplatformmedia;

import lombok.Data;

import java.io.Serializable;

@Data
public class MediaAccountBaseDTO implements Serializable {

    private static final long serialVersionUID = -6649692420441856076L;

    /**
     * 广告消耗（含增值）
     */
    private Double advertConsumerTotal=0.0;

    /**
     * 活动访问pv
     */
    private Long actRequestPV=0L;

    /**
     * 活动访问uv
     */
    private Long actRequestUV=0L;

    /**
     * 活动访问成功率：活动访问PV/入口素材点击PV
     */
    private String actRequestSuccessRate;

    /**
     * 活动首屏唤醒pv
     */
    private Long actWakePV=0L;

    /**
     * 活动首屏唤醒uv
     */
    private Long actWakeUV=0L;

    /**
     * 活动首屏唤醒成功率：活动首屏pv/活动访问PV
     */
    private String actWakeSuccessRate;

    /**
     * 活动加载完成pv
     */
    private Long actLoadPV=0L;

    /**
     * 活动加载完成uv
     */
    private Long actLoadUV=0L;

    /**
     * 活动加载成功率：活动加载完成PV/活动访问PV
     */
    private String actLoadSuccessRate;

    /**
     * 活动参与pv
     */
    private Long actJoinPV=0L;

    /**
     * 活动参与uv
     */
    private Long actJoinUV=0L;

    /**
     * 活动参与率（PV）：活动参与PV/活动访问PV
     */
    private String actJoinRatePV;

    /**
     * 活动参与率（UV）：活动参与UV/活动访问UV
     */
    private String actJoinRateUV;

    /**
     * PV活动参与：TODO
     */
    private String actJoinCount;

    /**
     * 复参数
     */
    private String complexParam;

    /**
     * 券请求量
     */
    private Long launchRequestInteract=0L;

    /**
     * 券请求成功率
     */
    private String launchRequestSuccessRate;

    /**
     * 券请求量（含增值）
     */
    private Long launchRequestPV=0L;

    /**
     * 券请求成功率（含增值）
     */
    private String launchRequestPVSuccessRate;

    /**
     * 发券量
     */
    private Long launchInteract=0L;

    /**
     * 发券成功率
     */
    private String launchInteractSuccessRate;

    /**
     * 付费券
     */
    private Long payLaunchInteract=0L;

    /**
     * 付费券占比
     */
    private String payLaunchInteractProportion;

    /**
     * 免费券
     */
    private Long freeLaunchInteract=0L;

    /**
     * 免费券占比
     */
    private String freeLaunchInteractProportion;

    /**
     * 作弊填充券
     */
    private Long riskLaunchInteract=0L;

    /**
     * 作弊填充占比
     */
    private String riskLaunchInteractProportion;

    /**
     * 发券量（含增值）
     */
    private Long launchPV=0L;

    /**
     * 发券成功率（含增值）
     */
    private String launchPVSuccessRate;

    /**
     * 付费券（含增值）
     */
    private Long payLaunchPV=0L;

    /**
     * 付费券占比（含增值）
     */
    private String payLaunchPVProportion;

    /**
     * 免费券（含增值）
     */
    private Long freeLaunchPV=0L;

    /**
     * 免费券占比（含增值）
     */
    private String freeLaunchPVProportion;

    /**
     * 作弊填充券（含增值）
     */
    private Long riskLaunchPV=0L;

    /**
     * 作弊填充占比（含增值）
     */
    private String riskLaunchPVProportion;

    /**
     * 每PV发券：发券量/活动访问PV
     */
    private String sendLaunchPerPV;

    /**
     * 每PV发券(含增值）：发券量含增值/入口素材点击PV
     */
    private String sendLaunchTotalPerPV;

    /**
     * 每UV发券：发券量/活动访问UV
     */
    private String sendLaunchPerUV;

    /**
     * 每UV发券（含增值）：发券量/活动访问UV
     */
    private String sendLaunchTotalPerUV;

    /**
     * 券曝光量
     */
    private Long launchExposureInteract=0L;

    /**
     * 券曝光量（含增值）
     */
    private Long launchExposurePV=0L;

    /**
     * 券曝光率（含增值）：券曝光（含增值）/发券量（含增值）
     */
    private String launchExposurePVRate;

    /**
     * 券有效点击量
     */
    private Long launchClickInteract=0L;

    /**
     * 券有效点击量（含增值）
     */
    private Long launchClickPV=0L;

    /**
     * 每PV点券：券点击/活动访问pv
     */
    private String couponPerPV;

    /**
     * 每PV点券（含增值）：券点击（含增值）/活动访问pv
     */
    private String totalCouponPerPV;

    /**
     * 每UV点券：券点击/活动访问uv
     */
    private String couponPerUV;

    /**
     * 每UV点券（含增值）：券点击（含增值）/活动访问uv
     */
    private String totalCouponPerUV;

    /**
     * 广告券点击率：券有效点击量/发券
     */
    private String launchClickRate;

    /**
     * 广告券点击率（含增值）：券有效点击量（含增值）/发券（含增值）
     */
    private String totalLaunchClickRate;

    /**
     * 消耗
     */
    private Double consumeInteract=0.0;

    /**
     * 消耗（含增值）
     */
    private Double consumeTotal=0.0;

    /**
     * 点击单价：消耗/券点击
     */
    private String clickPrice;

    /**
     * 点击单价（含增值）：消耗（含增值）/券点击（含增值）
     */
    private String totalClickPrice;

    /**
     * 每PV消耗
     */
    private String consumePerPV;

    /**
     * 每PV消耗（含增值）
     */
    private String totalConsumePerPV;

    /**
     * 每UV消耗：消耗/活动访问uv
     */
    private String consumePerUV;

    /**
     * 每UV消耗（含增值）：消耗（含增值）/活动访问uv
     */
    private String totalConsumePerUV;

    /**
     * 落地页曝光pv
     */
    private Long landingPageExposurePV=0L;

    /**
     * 落地页到达率：落地页曝光/券有效点击量
     */
    private String landingPageArriveRate;

    /**
     * 落地页转化pv
     */
    private Long landingPageConversionPV=0L;

    /**
     * 落地页转化率：落地页转化/落地页曝光
     */
    private String landingPageConversionRate;

    /**
     * 入口素材点击pv
     */
    private Long slotClickPV=0L;







}
