package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaManagerDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqMediaManagerCreateDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 媒体--管理员关联关系接口
 *
 * @author songjiaxing
 */
@AdvancedFeignClient
public interface RemoteMediaManagerBackendService {

    /**
     * 关联媒体和管理员
     *
     * @return
     */
    DubboResult<Integer> createMediaManager(ReqMediaManagerCreateDto createDto);

    /**
     * 批量关联媒体和管理员
     *
     * @return
     */
    DubboResult<Integer> createMediaManagerList(List<ReqMediaManagerCreateDto> createDtoList);

    /**
     * 批量关联媒体和管理员
     *
     * @return
     */
    Integer createMediaManagers(List<ReqMediaManagerCreateDto> createDtoList, Integer managerType);

    /**
     *
     * @param mediaIds  待删除的子账户媒体id
     * @param managerIds    待删除的子账户媒介运营账号id
     * @param managerType   管理员角色
     * @param createDtoList 待插入的代理商运营和代理商媒介
     * @return
     */
    DubboResult<Integer> incrementCreateMediaManagerList(List<Long> mediaIds, List<Long> managerIds, Integer managerType,List<ReqMediaManagerCreateDto> createDtoList);

    /**
     * 删除媒体和管理员关联关系
     *
     * @return
     */
    DubboResult<Integer> deleteByMediaId(Long mediaId);

    /**
     * 根据管理员id查询可操作的媒体
     *
     * @param managerId
     * @return
     */
    DubboResult<List<MediaManagerDto>> listByManagerId(Long managerId);

    /**
     * 根据媒体id查询所属管理员
     *
     * @param mediaId
     * @return
     */
    DubboResult<List<MediaManagerDto>> listByMediaId(Long mediaId);

    DubboResult<List<MediaManagerDto>> listByMediaList(List<Long> medias);

    /**
     * 根据管理员ids查询可操作的媒体
     *
     * @return
     */
    List<MediaManagerDto> listByManagerIds(List<Long> managerIds);

    int insert(MediaManagerDto record);

    /**
     * 查询所有未分配负责人的账号ID
     */
    List<Long> listNotAllocateManagerMediaId();

    DubboResult<List<MediaManagerDto>> listByMediaManagerByMedia(Long mediaId,Integer mainMedia);
}
