package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.constant.NewMediaTestEnum;
import cn.com.duiba.tuia.ssp.center.api.dto.*;
import cn.com.duiba.tuia.ssp.center.api.dto.media.ChangeNewMediaTestPeriodReq;
import cn.com.duiba.tuia.ssp.center.api.remote.mediaTest.dto.GainPaging;
import java.util.List;

/**
 * @Auther: fenglijun
 * @Date: 2019/8/8 11:24
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteNewMediaTestService {


    /**
     * 测试媒体
     * @param paging 分页信息
     * @return 处理结果
     */
    PageResultDto<NewMediaTestDto> gainTestMediaPaging(GainPaging paging);

    /**
     * 分页查询新媒体列表
     * @param req
     * @return
     */
    PageResultDto<NewMediaTestDto> pageList(ReqPageQuery req);

    /**
     * 参加或不参加测试
     * @param id
     * @param appMark
     * @return
     */
    int markApp(Long id, ReqMarkAppDto appMark);

    /**
     * 修改测试状态
     * @param appIds
     * @param statusEnum
     * @return
     */
    int modifyStatus(List<Long> appIds, NewMediaTestEnum.StatusEnum statusEnum);


    /**
     * 查询所有的在测试中的媒体
     * @return
     */
    List<NewMediaTestDto> getAllTestingMedia();


    int insert(List<Long> appIds);


    /**
     * @Author zhangliwei
     * @Description  更新优先级方法
     * @Date 16:53 2019-09-11
     * @Param [id, type]
     * @return int
     **/
    int updatePriority(Long id, Integer priority) throws BizException;

    /**
     * @Author zhangliwei
     * @Description  添加黑名单
     * @Date 15:53 2019-09-11
     * @Param [req]
     * @return int
     **/
    int addBlackList(List<Long> ids,Integer type);

    /**
     * @Author zhangliwei
     * @Description  移出黑名单
     * @Date 16:24 2019-09-11
     * @Param [id, type]
     * @return int
     **/
    int removeBlackList(Long id, Integer type);

    /**
     * @Author zhangliwei
     * @Description  分页查询黑名单列表
     * @Date 16:16 2019-09-11
     * @Param [req]
     * @return cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto<cn.com.duiba.tuia.ssp.center.api.dto.NewMediaTestDto>
     **/
    PageResultDto<NewMediaBlackListDto> getBlackListPageList(ReqPageQuery req);

    /**
     * @Author zhangliwei
     * @Description  同步回流表数据定时任务
     * @Date 15:16 2019-09-12
     * @Param []
     * @return boolean
     **/
    boolean  synchronizeBackFlow();

    /**
     * @Author zhangliwei
     * @Description  零点定时任务,重置所有新媒体测试记录状态为未测试
     * @Date 15:00 2019-10-11
     * @Param []
     * @return boolean
     **/
    boolean  clearNewMediaStatus();

    /**
     * @Author zhangliwei
     * @Description  根据大数据返回数据,定时将待测试状态数据更新为测试中
     * @Date 19:34 2019-10-11
     * @Param []
     * @return boolean
     **/
    boolean  updateTestStatusByData();

    /**
     * @Author zhangliwei
     * @Description  获取全量加入黑名单的app id 集合(包括将账号ID转换为对应的所有app id)
     * @Date 11:16 2019-10-12
     * @Param []
     * @return java.util.List<java.lang.Long>
     **/
    List<Long> getAllBlackListAppIds();

    /**
     * @Author zhangliwei
     * @Description  根据id集合获取新媒体测试对象
     * @Date 13:54 2019-10-12
     * @Param [ids]
     * @return java.util.List<cn.com.duiba.tuia.ssp.center.api.dto.NewMediaTestDto>
     **/
    List<NewMediaTestDto> getAllTestingMediaByIds(List<Long> ids);

    /**
     * 查询优先测试新媒体上限
     */
    Integer getNewMediaTestLimit();

    /**
     * 修改优先测试新媒体上限
     * @param newLimit 新上限
     * @return 结果 <code>true</code> 成功
     *             <code>false</code> 失败
     */
    boolean changeNewMediaTestLimit(Integer newLimit, String operatorId) throws BizException;

    /**
     * 调整新媒体测试周期
     *
     * @return
     */
    boolean changeTestPeriod(ChangeNewMediaTestPeriodReq changeRequest) throws BizException;

}
