package cn.com.duiba.tuia.ssp.center.api.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 〈字段 校验〉<p>
 * 〈功能详细描述〉
 *
 * @author zixiao
 * @date 17/12/11
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface FieldCheck {

    /**
     * 字段名
     * @return
     */
    String name() default "";

    /**
     * 不能为Null
     */
    boolean notNull() default false;

    /**
     * 不是为Null或者为空字符串，空数组，空集合
     */
    boolean notEmpty() default false;

    /**
     * 字段长度限制
     * 用于字符串
     */
    int maxLength() default -1;

    /**
     * 正则表达式验证
     * 用于字符串
     */
    String regex() default "";

}
