package cn.com.duiba.tuia.ssp.center.api.dto;


import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 媒体账户金额调整表
 */
@Data
public class AccountAdjustDTO implements Serializable {


    @ApiModelProperty(value = "ID")
    private Long id;
    /**
     * 媒体用户id
     */
    @ApiModelProperty(value = "媒体用户id")
    private Long mediaId;
    /**
     * 应用id
     */
    @ApiModelProperty(value = "应用id")
    private Long appId;
    /**
     * 月份
     */
    @ApiModelProperty(value = "月份")
    @JsonFormat(pattern = "yyyy-MM",timezone = "GMT+8")
    private Date curDate;
    /**
     * 审核状态：0-待结算，1-结算成功，2-拒绝结算
     */
    @ApiModelProperty(value = "审核状态：0-待结算，1-结算成功，2-拒绝结算")
    private Integer checkStatus;
    /**
     * 调账原因
     */
    @ApiModelProperty(value = "调账原因")
    private String reason;
    /**
     * 审核拒绝原因
     */
    @ApiModelProperty(value = "审核拒绝原因")
    private String refuseMsg;
    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String comment;
    /**
     * 杭州实际收入
     */
    @ApiModelProperty(value = "杭州实际收入")
    private Long hzFinalShare;
    /**
     * 霍城兑捷实际收入
     */
    @ApiModelProperty(value = "霍城兑捷实际收入")
    private Long hcdjFinalShare;
    /**
     * 霍尔果斯实际收入
     */
    @ApiModelProperty(value = "霍尔果斯实际收入")
    private Long hegsFinalShare;
    /**
     * 媒体实际收入
     */
    @ApiModelProperty(value = "媒体实际收入")
    private Long finalShare;
    /**
     * 杭州调整金额
     */
    @ApiModelProperty(value = "杭州调整金额")
    private Long hzAdjust;
    /**
     * 霍城兑捷调整金额
     */
    @ApiModelProperty(value = "霍城兑捷调整金额")
    private Long hcdjAdjust;
    /**
     * 霍尔果斯调整金额
     */
    @ApiModelProperty(value = "霍尔果斯调整金额")
    private Long hegsAdjust;
    /**
     * 媒体调整金额
     */
    @ApiModelProperty(value = "媒体调整金额")
    private Long adjust;
    /**
     * 凭证URL
     */
    @ApiModelProperty(value = "凭证URL")
    private String voucherUrl;
    /**
     * 记录创建时间
     */
    @ApiModelProperty(value = "记录创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date gmtCreate;
    /**
     * 记录修改时间
     */
    @ApiModelProperty(value = "记录修改时间")
    private Date gmtModified;

    /**
     * 操作人名称
     **/
    @ApiModelProperty(value = "操作人名称")
    private String managerName;
    /**
     * 操作人email
     **/
    @ApiModelProperty(value = "操作人email")
    private String managerEmail;
    /**
     * 操作人ID
     */
    @ApiModelProperty(value = "操作人ID")
    private Long managerId;

    /**
     * 操作人名称
     **/
    @ApiModelProperty(value = "审核人名称")
    private String auditName;
    /**
     * 操作人email
     **/
    @ApiModelProperty(value = "审核人email")
    private String auditEmail;
    /**
     * 操作人ID
     */
    @ApiModelProperty(value = "审核人ID")
    private Long auditId;

    @ApiModelProperty(value = "媒体名称")
    private String appName;

    @ApiModelProperty(value = "账号名称(Email)")
    private String  account;

    @ApiModelProperty(value = "月报表ID")
    private Long reportId;

    /**
     * 杭州实际收入(调账后)
     */
    private Long hzFinalShareAdjusted;
    /**
     * 霍城兑捷实际收入(调账后)
     */
    private Long hcdjFinalShareAdjusted;
    /**
     * 霍尔果斯实际收入(调账后)
     */
    private Long hegsFinalShareAdjusted;

}
