package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * 收藏素材请求参数
 *
 * @author zhangzhenghe
 * @since 2020-02-04 11:13 AM
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ReqMaterialFavorite extends BaseQueryDto implements Serializable {

    private static final long serialVersionUID = -3521220597078968357L;

    /**
     * 素材ID
     */
    private Long id;

    /**
     * 素材ID列表
     */
    private List<Long> ids;

    /**
     * 素材标题
     */
    private String title;

    /**
     * 素材标签ID列表
     */
    private String tagIds;

    /**
     * 素材标签ID列表
     */
    private List<Long> tagIdList;

    /**
     * 素材开启状态，0：关闭，1：开启，不传：全部
     */
    private Integer enableStatus;

    /**
     * 广告位规格ID
     */
    private Long msId;

    /**
     * 素材分类(0:动态素材 1:静态素材 3:视频素材)
     */
    private String pictureType;

    /**
     * 用户ID
     */
    private Long managerId;

    /**
     * 格式类型，0-普通格式，1-svga格式
     */
    private Integer formatType;
}
