package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.ActivityManualPlanDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * 手动投放活动后台service
 */
@AdvancedFeignClient
public interface RemoteActivityManualBackendService {

	/**
	 * @param manualPlan
	 * @return
	 */
	DubboResult<Boolean> addActivityManualPlan(ActivityManualPlanDto manualPlan);

	/**
	 * @param manualPlan
	 * @return
	 */
	Boolean addActivityManualPlanDistinguishDeep(ActivityManualPlanDto manualPlan,Map<String,Object> deepMap);

	/**
	 * @param planDto
	 * @return
	 */
	DubboResult<Boolean> modifyActivityManualPlan(ActivityManualPlanDto planDto);

	/**
	 * @param planDto
	 * @return
	 */
	DubboResult<Boolean> removeActivityManualPlan(ActivityManualPlanDto planDto);

	/**
	 * @param activityId
	 * @param source
	 * @return
	 */
	DubboResult<List<Long>> findActivityManualPlanSlotBySource(Long activityId, Integer source);
	
	/**
     * @param slotId
     * @return
     */
    DubboResult<List<ActivityManualPlanDto>> findActivityManualPlans(Long slotId, Map<Integer, String> actTypeMap);

	/**
	 * 根据活动ID列表查询
	 *
	 * @param activityIdList
	 * @param source
	 * @return
	 */
	List<ActivityManualPlanDto> selectByActivityIdListAndSource(List<Long> activityIdList, Integer source);

	/**
	 * 按地域获取依次投放活动-定时的活动列表
	 * @param slotId
	 * @param regionId
	 * @param actTypeMap
	 * @return
	 */
	List<ActivityManualPlanDto> findActivityManualPlansByRegion(Long slotId, Long regionId, Map<Integer, String> actTypeMap);

	List<ActivityManualPlanDto> findActivityManualPlansByRegionV1(Long slotId, Long regionId,
			Byte belongToGroup, Map<Integer, String> actTypeMap);

	ActivityManualPlanDto getById(ActivityManualPlanDto planDto);

	/**
	 * @param planDto
	 * @return
	 */
	Boolean removeActivityManualPlanDistingguishDeep(ActivityManualPlanDto planDto,Map<String,Object> deepMap);
}
