package cn.com.duiba.tuia.ssp.center.api.remote.media.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

/**
 * 标识枚举
 * 注: 素材测试标识.
 * @dateTime 2021-01-18 17:51:27
 * @author haitao.hua
 */
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = true, chain = true, prefix = "")
public enum TestingMarkEnum {

    /*################################# 素材投放开关的枚举 ( Start ) #####################################*/

    Ordinary(0, "普通素材"),
    Testing(1, "测试素材");

    /*################################# 素材投放开关的枚举 ( end ) #######################################*/

    /**
     * 标识码
     */
    @Getter
    private Integer code;

    /**
     * 备注
     */
    @Getter
    private String remark;

    /**
     * Seek 值
     * @param code 标识码
     * @return 结果
     */
    public static TestingMarkEnum seekValue(Integer code) {
        Optional<TestingMarkEnum> result = Arrays.stream(TestingMarkEnum.values()).filter(target -> (Objects.nonNull(target) && target.code.equals(code))).findFirst();
        return result.orElse(null);
    }

}
