package cn.com.duiba.tuia.ssp.center.api.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 今日流量调整
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ReqSlotFlowConfig extends ReqPageQuery{

    private static final long serialVersionUID = -2573307578912411560L;

    /**
     * 媒体ID
     */
    private Long appId;

    /**
     * 广告位ID
     */
    private Long slotId;

    /**
     * 计费方式（0:分成 1:CPC 2:CPM 3:UV单价 4:CPT）
     */
    private Integer chargeType;

    /**
     * 流量调整比例
     */
    private Integer currentRatio;

    /**
     * 开始时间 格式 yyyy-MM-dd hh:mm:ss
     */
    @JsonIgnore
    private Date startDate;

    /**
     * 结束时间 格式 yyyy-MM-dd hh:mm:ss
     */
    @JsonIgnore
    private Date endDate;
}

