/**
 * Project Name:media-biz<br/>
 * File Name:ReqAdsenseList.java<br/>
 * Package Name:cn.com.duiba.tuia.media.model.req<br/>
 * Date:2016年9月28日下午3:45:39<br/>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 广告位列表请求参数 <br/>
 * Date: 2016年9月28日 下午3:45:39 <br/>
 * 
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */
public class ReqSlotList extends BaseQueryDto {

    private static final long serialVersionUID = -7547539198840224448L;

    @ApiModelProperty(value = "广告位ID", required = false)
    private Long              slotId;

    @ApiModelProperty(value = "广告位名称", required = false)
    private String            slotName;

    @ApiModelProperty(value = "媒体账号ID", required = true)
    private Long              mediaId;

    @ApiModelProperty(value = "审核状态", required = true)
    private Integer           checkStatus;

    @ApiModelProperty(value = "广告位状态", required = true)
    private Integer           enableStatus;

    private List<Long>        appIds;

    /**
     * 删除状态:0-未删除;1-已删除
     */
    private Integer           deleteStatus;


    /**
     * 广告位id列表
     */
    private List<Long>  slotIds;


    /**
     * 广告位类型
     */
    private List<Integer> slotAccessTypes;

    /**
     * 是否介入sdk
     * */
    private Integer isSdk;

    public ReqSlotList() {
    }

    public ReqSlotList(List<Long> appIds, Integer deleteStatus) {
        this.appIds = appIds;
        this.deleteStatus = deleteStatus;
    }

    public ReqSlotList(Long mediaId, List<Long> appIds) {
        this.mediaId = mediaId;
        this.appIds = appIds;
    }

    /**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * slotName.
     *
     * @return the slotName
     * @since JDK 1.6
     */
    public String getSlotName() {
        return slotName;
    }

    /**
     * slotName.
     *
     * @param slotName the slotName to set
     * @since JDK 1.6
     */
    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    /**
     * mediaId.
     *
     * @return the mediaId
     * @since JDK 1.6
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * mediaId.
     *
     * @param mediaId the mediaId to set
     * @since JDK 1.6
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    /**
     * checkStatus.
     *
     * @return the checkStatus
     * @since JDK 1.6
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * checkStatus.
     *
     * @param checkStatus the checkStatus to set
     * @since JDK 1.6
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    /**
     * enableStatus.
     *
     * @return the enableStatus
     * @since JDK 1.6
     */
    public Integer getEnableStatus() {
        return enableStatus;
    }

    /**
     * enableStatus.
     *
     * @param enableStatus the enableStatus to set
     * @since JDK 1.6
     */
    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    public List<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(List<Long> appIds) {
        this.appIds = appIds;
    }

    public Integer getDeleteStatus() {
        return deleteStatus;
    }

    public void setDeleteStatus(Integer deleteStatus) {
        this.deleteStatus = deleteStatus;
    }

    public List<Long> getSlotIds() {
        return slotIds;
    }

    public void setSlotIds(List<Long> slotIds) {
        this.slotIds = slotIds;
    }

    public List<Integer> getSlotAccessTypes() {
        return slotAccessTypes;
    }

    public void setSlotAccessTypes(List<Integer> slotAccessTypes) {
        this.slotAccessTypes = slotAccessTypes;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public Integer getIsSdk() {
        return isSdk;
    }

    public void setIsSdk(Integer isSdk) {
        this.isSdk = isSdk;
    }
}
