package cn.com.duiba.tuia.ssp.center.api.util.concurrent;

import java.util.concurrent.Callable;

/**
 * 抽象的任务提供者,负责为{@link EnhanceCompletionService}提供处理任务
 *
 * @see EnhanceCompletionService
 * @see AbstractResultConsumer
 * @author ikongyi
 * @since 2021.07.21
 */
public abstract class AbstractTaskProvider<V, S> {

    /**
     * 提交所有的任务到{@link EnhanceCompletionService}中
     * <p>
     * 提交单个任务时需要使用 {@link EnhanceCompletionService#submit(Callable)} 方法<br/>
     * 该方法允许分页查询,并不影响消费线程消费结果
     */
    public abstract void offerTasks(EnhanceCompletionService<V, S> ecs);
}