/**
 * Project Name:media-api File Name:AccountDayReportDto.java Package Name:cn.com.duiba.tuia.media.api.dto
 * Date:2016年11月30日下午3:06:46 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * ClassName:AccountDayReport <br/>
 * Function: 媒体用户日报表. <br/>
 * Date: 2016年11月30日 下午3:06:46 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class AccountDayReportDto implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = 3266371532640694635L;

    /** id */
    private Long              id;

    /** 媒体用户id */
    private Long              mediaId;

    /** 媒体id */
    private Long              appId;

    /** 广告id */
    private Long              slotId;

    /** 每日曝光数 */
    private Long           exposureCount;

    /** 每日点击数 */
    private Long           clickCount;

    /** 每日发券量 */
    private Long           launchCount;

    /** 广告点击量 */
    private Long           efClickCount;

    /** 每日点击uv */
    private Long           clickCountUv;

    /** 每日消费(精确到分后面两位小数) */
    private Long              consumeTotal;

    /** 每日预计分成(分) */
    private Long              exConsumeTotal;

    /** 每日广告消耗(分) */
    private Long              adConsume;

    /** 当天日期 */
    private Date              curDate;

    /** 广告位曝光  */
    private Long        actExposeCount;

    /** 广告位点击  */
    private Long        actClickCount;

    /** 广告位访问UV  */
    private Long        sdkUv;

    /** 活动广告券请求  */
    private Long        advertRequestCount;

    /** 管理员名称 */
    private List<String> managerNameList;
    
    /**活动请求uv*/
    private  Long       actRequestUv;

    /**结算日期**/
    private Date gmtCreate;
    
    /**杭州每日广告消耗(分)*/
    private Long hzAdConsume;
    
    /**杭州每日媒体预计分成(分）*/
    private Long hzExConsumeTotal;
    
    /**杭州每日消费(分)*/
    private Long hzConsumeTotal;
    
    /**霍尔果斯每日广告消耗(分)*/
    private Long hegsAdConsume;
    
    /**霍尔果斯每日媒体预计分成(分）*/
    private Long hegsExConsumeTotal;
    
    /**霍尔果斯每日消费(分)*/
    private Long hegsConsumeTotal;

    /**霍城兑捷每日广告消耗(分)*/
    private Long hcdjAdConsume;

    /**霍城兑捷每日媒体预计分成(分）*/
    private Long hcdjExConsumeTotal;

    /**霍城兑捷每日消费(分)*/
    private Long hcdjConsumeTotal;
    /** 现金消耗 */
    private Long  cashConsume;
    /** 杭州现金消耗*/
    private Long   hzCashConsume;
    /** 霍尔果斯现金消耗*/
    private Long   hegsCashConsume;

    /** 霍城兑捷现金消耗*/
    private Long   hcdjCashConsume;

    /**杭州实际分成*/
    private Long hzMediaDueDivide;

    /**霍尔果思实际分成*/
    private Long hegsMediaDueDivide;

    /**霍城兑捷实际分成*/
    private Long hcdjMediaDueDivide;

    /**
     * 媒体应得分成(精确到分)
     */
    private Long mediaDueDivide;

    /** 记录修改时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date gmtModified;

    /** 媒体预计分成按分存储 */
    private Long mediaExDivide;

    /** 杭州媒体预计分成按分存储 */
    private Long hzMediaExDivide;

    /** 霍尔果斯媒体预计分成按分存储 */
    private Long hegsMediaExDivide;

    /** 是否已结算0未结算 1已结算 */
    private Integer settled;

    /** 霍城兑捷州媒体预计分成按分存储 */
    private Long hcdjMediaExDivide;

    public AccountDayReportDto() {
        super();
    }
    
    public AccountDayReportDto(Long mediaId, Long appId, Date curDate, Date gmtCreate) {
        super();
        this.mediaId = mediaId;
        this.appId = appId;
        this.curDate = curDate;
        this.gmtCreate = gmtCreate;
    }
    /**
     * id.
     *
     * @return the id
     * @since JDK 1.6
     */
    public Long getId() {
        return id;
    }

    /**
     * id.
     *
     * @param id the id to set
     * @since JDK 1.6
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * exposureCount.
     *
     * @return the exposureCount
     * @since JDK 1.6
     */
    public Long getExposureCount() {
        return exposureCount;
    }

    /**
     * exposureCount.
     *
     * @param exposureCount the exposureCount to set
     * @since JDK 1.6
     */
    public void setExposureCount(Long exposureCount) {
        this.exposureCount = exposureCount;
    }

    /**
     * clickCount.
     *
     * @return the clickCount
     * @since JDK 1.6
     */
    public Long getClickCount() {
        return clickCount;
    }

    /**
     * clickCount.
     *
     * @param clickCount the clickCount to set
     * @since JDK 1.6
     */
    public void setClickCount(Long clickCount) {
        this.clickCount = clickCount;
    }

    /**
     * launchCount.
     *
     * @return the launchCount
     * @since JDK 1.6
     */
    public Long getLaunchCount() {
        return launchCount;
    }

    /**
     * launchCount.
     *
     * @param launchCount the launchCount to set
     * @since JDK 1.6
     */
    public void setLaunchCount(Long launchCount) {
        this.launchCount = launchCount;
    }

    /**
     * efClickCount.
     *
     * @return the efClickCount
     * @since JDK 1.6
     */
    public Long getEfClickCount() {
        return efClickCount;
    }

    /**
     * efClickCount.
     *
     * @param efClickCount the efClickCount to set
     * @since JDK 1.6
     */
    public void setEfClickCount(Long efClickCount) {
        this.efClickCount = efClickCount;
    }

    /**
     * consumeTotal.
     *
     * @return the consumeTotal
     * @since JDK 1.6
     */
    public Long getConsumeTotal() {
        return consumeTotal;
    }

    /**
     * consumeTotal.
     *
     * @param consumeTotal the consumeTotal to set
     * @since JDK 1.6
     */
    public void setConsumeTotal(Long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    /**
     * curDate.
     *
     * @return the curDate
     * @since JDK 1.6
     */
    public Date getCurDate() {
        return curDate;
    }

    /**
     * curDate.
     *
     * @param curDate the curDate to set
     * @since JDK 1.6
     */
    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    /**
     * mediaId.
     *
     * @return the mediaId
     * @since JDK 1.6
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * mediaId.
     *
     * @param mediaId the mediaId to set
     * @since JDK 1.6
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    /**
     * appId.
     *
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * clickCountUv.
     *
     * @return the clickCountUv
     * @since JDK 1.6
     */
    public Long getClickCountUv() {
        return clickCountUv;
    }

    /**
     * clickCountUv.
     *
     * @param clickCountUv the clickCountUv to set
     * @since JDK 1.6
     */
    public void setClickCountUv(Long clickCountUv) {
        this.clickCountUv = clickCountUv;
    }

    /**
     * exConsumeTotal.
     *
     * @return the exConsumeTotal
     * @since JDK 1.6
     */
    public Long getExConsumeTotal() {
        return exConsumeTotal;
    }

    /**
     * exConsumeTotal.
     *
     * @param exConsumeTotal the exConsumeTotal to set
     * @since JDK 1.6
     */
    public void setExConsumeTotal(Long exConsumeTotal) {
        this.exConsumeTotal = exConsumeTotal;
    }

    /**
     * adConsume.
     *
     * @return the adConsume
     * @since JDK 1.6
     */
    public Long getAdConsume() {
        return adConsume;
    }

    /**
     * adConsume.
     *
     * @param adConsume the adConsume to set
     * @since JDK 1.6
     */
    public void setAdConsume(Long adConsume) {
        this.adConsume = adConsume; 
    }

    public Long getActExposeCount() {
        return actExposeCount;
    }

    public void setActExposeCount(Long actExposeCount) {
        this.actExposeCount = actExposeCount;
    }

    public Long getActClickCount() {
        return actClickCount;
    }

    public void setActClickCount(Long actClickCount) {
        this.actClickCount = actClickCount;
    }

    public Long getSdkUv() {
        return sdkUv;
    }

    public void setSdkUv(Long sdkUv) {
        this.sdkUv = sdkUv;
    }

    public Long getAdvertRequestCount() {
        return advertRequestCount;
    }

    public void setAdvertRequestCount(Long advertRequestCount) {
        this.advertRequestCount = advertRequestCount;
    }

    public List<String> getManagerNameList() {
        return managerNameList;
    }

    public void setManagerNameList(List<String> managerNameList) {
        this.managerNameList = managerNameList;
    }
    
    public Long getActRequestUv() {
        return actRequestUv;
    }

    
    public void setActRequestUv(Long actRequestUv) {
        this.actRequestUv = actRequestUv;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }
    public Long getHzAdConsume() {
        return hzAdConsume;
    }

    
    public void setHzAdConsume(Long hzAdConsume) {
        this.hzAdConsume = hzAdConsume;
    }

    
    public Long getHzExConsumeTotal() {
        return hzExConsumeTotal;
    }

    
    public void setHzExConsumeTotal(Long hzExConsumeTotal) {
        this.hzExConsumeTotal = hzExConsumeTotal;
    }

    
    public Long getHzConsumeTotal() {
        return hzConsumeTotal;
    }

    
    public void setHzConsumeTotal(Long hzConsumeTotal) {
        this.hzConsumeTotal = hzConsumeTotal;
    }

    
    public Long getHegsAdConsume() {
        return hegsAdConsume;
    }

    
    public void setHegsAdConsume(Long hegsAdConsume) {
        this.hegsAdConsume = hegsAdConsume;
    }

    
    public Long getHegsExConsumeTotal() {
        return hegsExConsumeTotal;
    }

    
    public void setHegsExConsumeTotal(Long hegsExConsumeTotal) {
        this.hegsExConsumeTotal = hegsExConsumeTotal;
    }

    
    public Long getHegsConsumeTotal() {
        return hegsConsumeTotal;
    }

    
    public void setHegsConsumeTotal(Long hegsConsumeTotal) {
        this.hegsConsumeTotal = hegsConsumeTotal;
    }

    public Long getHzMediaDueDivide() {
        return hzMediaDueDivide;
    }

    public void setHzMediaDueDivide(Long hzMediaDueDivide) {
        this.hzMediaDueDivide = hzMediaDueDivide;
    }

    public Long getHegsMediaDueDivide() {
        return hegsMediaDueDivide;
    }

    public void setHegsMediaDueDivide(Long hegsMediaDueDivide) {
        this.hegsMediaDueDivide = hegsMediaDueDivide;
    }

    public Long getMediaDueDivide() {
        return mediaDueDivide;
    }

    public void setMediaDueDivide(Long mediaDueDivide) {
        this.mediaDueDivide = mediaDueDivide;
    }

    public Long getCashConsume() {
        return cashConsume;
    }

    public void setCashConsume(Long cashConsume) {
        this.cashConsume = cashConsume;
    }

    public Long getHzCashConsume() {
        return hzCashConsume;
    }

    public void setHzCashConsume(Long hzCashConsume) {
        this.hzCashConsume = hzCashConsume;
    }

    public Long getHegsCashConsume() {
        return hegsCashConsume;
    }

    public void setHegsCashConsume(Long hegsCashConsume) {
        this.hegsCashConsume = hegsCashConsume;
    }

    public Long getHcdjAdConsume() {
        return hcdjAdConsume;
    }

    public void setHcdjAdConsume(Long hcdjAdConsume) {
        this.hcdjAdConsume = hcdjAdConsume;
    }

    public Long getHcdjExConsumeTotal() {
        return hcdjExConsumeTotal;
    }

    public void setHcdjExConsumeTotal(Long hcdjExConsumeTotal) {
        this.hcdjExConsumeTotal = hcdjExConsumeTotal;
    }

    public Long getHcdjConsumeTotal() {
        return hcdjConsumeTotal;
    }

    public void setHcdjConsumeTotal(Long hcdjConsumeTotal) {
        this.hcdjConsumeTotal = hcdjConsumeTotal;
    }

    public Long getHcdjMediaDueDivide() {
        return hcdjMediaDueDivide;
    }

    public void setHcdjMediaDueDivide(Long hcdjMediaDueDivide) {
        this.hcdjMediaDueDivide = hcdjMediaDueDivide;
    }

    public Long getHcdjCashConsume() {
        return hcdjCashConsume;
    }

    public void setHcdjCashConsume(Long hcdjCashConsume) {
        this.hcdjCashConsume = hcdjCashConsume;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getMediaExDivide() {
        return mediaExDivide;
    }

    public void setMediaExDivide(Long mediaExDivide) {
        this.mediaExDivide = mediaExDivide;
    }

    public Long getHzMediaExDivide() {
        return hzMediaExDivide;
    }

    public void setHzMediaExDivide(Long hzMediaExDivide) {
        this.hzMediaExDivide = hzMediaExDivide;
    }

    public Long getHegsMediaExDivide() {
        return hegsMediaExDivide;
    }

    public void setHegsMediaExDivide(Long hegsMediaExDivide) {
        this.hegsMediaExDivide = hegsMediaExDivide;
    }

    public Integer getSettled() {
        return settled;
    }

    public void setSettled(Integer settled) {
        this.settled = settled;
    }

    public Long getHcdjMediaExDivide() {
        return hcdjMediaExDivide;
    }

    public void setHcdjMediaExDivide(Long hcdjMediaExDivide) {
        this.hcdjMediaExDivide = hcdjMediaExDivide;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
