package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * @author xuyenan
 * @createTime 2016/12/21
 */
public class RspActivitySlotDto implements Serializable {

    private static final long serialVersionUID = 1104337713819885160L;

    private Long              slotId;                                 // 广告位ID
    private String            slotName;                               // 广告位名称
    private Long              appId;                                  // 媒体ID
    private String            appName;                                // 媒体名称
    private String            msName;                                 // 广告位规格
    private Integer           amount;                                 // 数量
    private Integer           directMode;                             // 定向模式
    private Integer           slotType;                               // 广告位类型
    private Long              slotMsId;                               // 规格ID
    private Integer           isDubious;                              //是否是可疑广告位
    private String            slotTypeName;                           //广告位类型描述
    private Integer           sckType;                                //手动投放素材类型
    private Integer           showSck;                                //展示素材入口


    /** 广告位开启状态 */
    private Integer           enableStatus;

    /** 审核状态. */
    private Integer           checkStatus;

    /**创建时间 */
    private Date gmtCreate;

    /**创建时间 (yyyy-MM-dd HH:mm:ss)*/
    private String 			  gmtCreateStr;

    /** 规格是否有效 */
    private Boolean           valid;

    /** 广告位投放方式 */
    private Integer    		  activityPutWay;

    /**媒体冻结状态*/
    private Integer           mediaFrozenStatus;

    /**广告位冻结状态*/
    private Integer           slotFrozenStatus;

    /**广告位冻结原因*/
    private String            slotFrozenReason;

    /** 删除状态 */
    private Integer           deleteStatus;

    /** 接入广告类型 0-互动广告 1-展示广告 */
    private Integer           slotAccessType;

    private Integer           incentiveSwitch;                       // 激励开关(0-关闭，1-默认，2-自定义)

    /**
     * 测试计划状态: 0-关闭 1-开启 2-结束
     */
    private Integer planStatus;

    /**
     * 测试计划ID
     */
    private Long planId;

    /**
     * 预警类型(没有值则为无 1:活动效益变差 2:优质活动占比需提升 3:长期未更换活动)
     */
    private Integer prewarningType;

    /**
     * 预警类型为3:长期未更换活动，时间长度
     */
    private Integer dateNum;

    private Integer sceneType;

    private String elements;

    /**
     * 告警状态: 0-不需告警 1-需要告警
     */
    private Integer warnStatus;

    /**
     * 算法候选池可用素材数量
     */
    private Integer algoSckNum;

    private Integer bindSvga;

    /** 尺寸标题 **/
    private String title;

    /**
     * 算法推荐开关  0-关闭 1-开启
     */
    private Integer scAlgoStatus;

    /**
     * 素材匹配开关  0-关闭 1-开启
     */
    private Integer autoFill;

    /**
     * 素材审核开关  0-关闭 1-开启
     */
    private Integer sckCheckSwitch;

    /**
     * 广告位链接宏替换开关 0-关，1-开
     */
    private Integer tuParamStatus;

    /**
     * 未经修改素材类型
     * 用于【是否使用推啊素材】
     */
    private Integer originSckType;
    /**
     * 链接审核数量
     */
    private Integer advertLinkAuditCount;

    /**
     * 可投广告位列表: 0-关闭 1-开启
     */
    private Integer openAvailableAdvertisementsList;
    /**
     * 落地页链接审核开关 0-关闭 1-开启
     */
    private Integer isLandPageAudit;
    /**
     * 用途说明
     */
    private String purposeExplain;

    /**
     * 是否在ABtest 广告位黑名单中
     */
    private Boolean inABtestBlack;

    public Boolean getInABtestBlack() {
        return inABtestBlack;
    }

    public void setInABtestBlack(Boolean inABtestBlack) {
        this.inABtestBlack = inABtestBlack;
    }

    public String getPurposeExplain() {
        return purposeExplain;
    }

    public void setPurposeExplain(String purposeExplain) {
        this.purposeExplain = purposeExplain;
    }

    public Integer getOpenAvailableAdvertisementsList() {
        return openAvailableAdvertisementsList;
    }

    public void setOpenAvailableAdvertisementsList(Integer openAvailableAdvertisementsList) {
        this.openAvailableAdvertisementsList = openAvailableAdvertisementsList;
    }

    public Integer getIsLandPageAudit() {
        return isLandPageAudit;
    }

    public void setIsLandPageAudit(Integer isLandPageAudit) {
        this.isLandPageAudit = isLandPageAudit;
    }

    public Integer getAdvertLinkAuditCount() {
        return advertLinkAuditCount;
    }

    public void setAdvertLinkAuditCount(Integer advertLinkAuditCount) {
        this.advertLinkAuditCount = advertLinkAuditCount;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public String getSlotName() {
        return slotName;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public Integer getDirectMode() {
        return directMode;
    }

    public void setDirectMode(Integer directMode) {
        this.directMode = directMode;
    }

    public String getMsName() {
        return msName;
    }

    public void setMsName(String msName) {
        this.msName = msName;
    }
    public Integer getSlotType() {
        return slotType;
    }


    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }


    public Long getSlotMsId() {
        return slotMsId;
    }

    public void setSlotMsId(Long slotMsId) {
        this.slotMsId = slotMsId;
    }

    public Integer getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public String getGmtCreateStr() {
        return gmtCreateStr;
    }

    public void setGmtCreateStr(String gmtCreateStr) {
        this.gmtCreateStr = gmtCreateStr;
    }

    public Boolean getValid() {
        return valid;
    }

    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    public Integer getActivityPutWay() {
        return activityPutWay;
    }

    public void setActivityPutWay(Integer activityPutWay) {
        this.activityPutWay = activityPutWay;
    }

    public Integer getIsDubious() {
        return isDubious;
    }

    public void setIsDubious(Integer isDubious) {
        this.isDubious = isDubious;
    }

    public Integer getMediaFrozenStatus() {
        return mediaFrozenStatus;
    }


    public void setMediaFrozenStatus(Integer mediaFrozenStatus) {
        this.mediaFrozenStatus = mediaFrozenStatus;
    }


    public Integer getSlotFrozenStatus() {
        return slotFrozenStatus;
    }


    public void setSlotFrozenStatus(Integer slotFrozenStatus) {
        this.slotFrozenStatus = slotFrozenStatus;
    }


    public String getSlotFrozenReason() {
        return slotFrozenReason;
    }


    public void setSlotFrozenReason(String slotFrozenReason) {
        this.slotFrozenReason = slotFrozenReason;
    }

    public Integer getDeleteStatus() {
        return deleteStatus;
    }

    public void setDeleteStatus(Integer deleteStatus) {
        this.deleteStatus = deleteStatus;
    }

    public String getSlotTypeName() {
        return slotTypeName;
    }

    public void setSlotTypeName(String slotTypeName) {
        this.slotTypeName = slotTypeName;
    }

    public Integer getSckType() {
        return sckType;
    }

    public void setSckType(Integer sckType) {
        this.sckType = sckType;
    }

    public Integer getShowSck() {
        return showSck;
    }

    public void setShowSck(Integer showSck) {
        this.showSck = showSck;
    }


    public Integer getSlotAccessType() {
        return slotAccessType;
    }

    public void setSlotAccessType(Integer slotAccessType) {
        this.slotAccessType = slotAccessType;
    }

    public Integer getIncentiveSwitch() {
        return incentiveSwitch;
    }

    public void setIncentiveSwitch(Integer incentiveSwitch) {
        this.incentiveSwitch = incentiveSwitch;
    }

    public Integer getPlanStatus() {
        return planStatus;
    }

    public void setPlanStatus(Integer planStatus) {
        this.planStatus = planStatus;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public Integer getPrewarningType() {
        return prewarningType;
    }

    public void setPrewarningType(Integer prewarningType) {
        this.prewarningType = prewarningType;
    }

    public Integer getDateNum() {
        return dateNum;
    }

    public void setDateNum(Integer dateNum) {
        this.dateNum = dateNum;
    }

    public Integer getSceneType() {
        return sceneType;
    }

    public void setSceneType(Integer sceneType) {
        this.sceneType = sceneType;
    }

    public String getElements() {
        return elements;
    }

    public void setElements(String elements) {
        this.elements = elements;
    }

    public Integer getWarnStatus() {
        return warnStatus;
    }

    public void setWarnStatus(Integer warnStatus) {
        this.warnStatus = warnStatus;
    }

    public Integer getAlgoSckNum() {
        return algoSckNum;
    }

    public void setAlgoSckNum(Integer algoSckNum) {
        this.algoSckNum = algoSckNum;
    }

    public Integer getBindSvga() {
        return bindSvga;
    }

    public void setBindSvga(Integer bindSvga) {
        this.bindSvga = bindSvga;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getScAlgoStatus() {
        return scAlgoStatus;
    }

    public void setScAlgoStatus(Integer scAlgoStatus) {
        this.scAlgoStatus = scAlgoStatus;
    }

    public Integer getAutoFill() {
        return autoFill;
    }

    public void setAutoFill(Integer autoFill) {
        this.autoFill = autoFill;
    }

    public Integer getSckCheckSwitch() {
        return sckCheckSwitch;
    }

    public void setSckCheckSwitch(Integer sckCheckSwitch) {
        this.sckCheckSwitch = sckCheckSwitch;
    }

    public Integer getTuParamStatus() {
        return tuParamStatus;
    }

    public void setTuParamStatus(Integer tuParamStatus) {
        this.tuParamStatus = tuParamStatus;
    }

    public Integer getOriginSckType() {
        return originSckType;
    }

    public void setOriginSckType(Integer originSckType) {
        this.originSckType = originSckType;
    }
}
