package cn.com.duiba.tuia.ssp.center.api.dto.externalplatformmedia;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class ExternalPlatformMediaDataDTO implements Serializable {

    private static final long serialVersionUID = -1L;

    /**
     * 账号id
     */
    private Long id;
    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 媒体标识符 爱奇艺-0 快手-1 奇虎260-2 OPPO-3 百度-4 芒果-5 微博-6 广点通-7 VIVO-8
     */
    private Integer mediaType;

    /**
     * 账号名称
     */
    private String accountName;

    /**
     * 媒体消耗
     */
    private BigDecimal mediaConsume;

    /**
     * 入口素材曝光数
     */
    private Long entryMaterialExposureCount;

    /**
     * 入口素材点击数
     */
    private Long entryMaterialClickCount;

    /**
     * 运营人员
     */
    private String operatorName;

    /**
     * 运营人员id
     */
    private Long operatorId;

    /**
     * 广告位id
     */
    private String slotId;

    /**
     * 是否删除:0.未删除 1.已删除
     */
    private Integer isDeleted;

    /**
     * 代理名称
     */
    private String agentName;

    /**
     * 子账号
     */
    private String childrenId;

    /**
     * 媒体id
     */
    private String appId;
    /**
     * 当前时间
     */
    private Date curDate;
    /**
     * 外部媒体id
     */
    private Long extAccountId;
    /**
     * 起始时间
     */
    private Date startTime;

    private List<Long> extAccountIds;
    /**
     * 结束时间
     */
    private Date endTime;

    private Integer currentPage;

    private Integer pageSize;

    private Integer rowStart;
    /**
     * 操作人id列表
     */
    private List<Long> operatorIds;

    /**
     * 媒体返点
     */
    private BigDecimal mediaRebate;

    /**
     * 落地页数据-表单提交数
     */
    private Long formCount;
    /**
     * 落地页数据-表单提交单价
     */
    private BigDecimal formCost;
    /**
     * 落地页数据-表单提交点击率
     */
    private BigDecimal formActionRatio;
    /**
     * 应用下载数据-注册数
     */
    private Long eventRegister;
    /**
     * 应用下载数据-注册成本
     */
    private BigDecimal eventRegisterCost;
    /**
     * 应用下载数据-注册率
     */
    private BigDecimal eventRegisterRatio;
    /**
     * 新增付费人数
     */
    private Long eventNewUserPay;
    /**
     * 新增付费人数成本：当日消耗 / 当日新增付费人数
     */
    private BigDecimal eventNewUserPayCost;
    /**
     * 新增付费人数率：当日新增付费人数 / 当日行为数
     */
    private BigDecimal eventNewUserPayRatio;

}
