/**
 * Project Name:media-biz<br/>
 * File Name:AdsenseDto.java<br/>
 * Package Name:cn.com.duiba.tuia.media.domain<br/>
 * Date:2016年9月26日下午5:05:11<br/>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.Date;

/**
 * 广告位Dto <br/>
 * Date: 2016年9月26日 下午5:05:11 <br/>
 *
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */
public class SlotDto extends BaseDto {

    /** 广告位类型 0-插屏. */
    public static final int    ADSENSE_TYPE_PLAQUE                        = 0;
    /** 广告位类型 1-横幅. */
    public static final int    ADSENSE_TYPE_STREAMER_BANNER               = 1;
    /** 广告位类型 2-信息流. */
    public static final int    ADSENSE_TYPE_INFORMATION_STREAM            = 2;
    /** 广告位类型 3-banner. */
    public static final int    ADSENSE_TYPE_BANNER                        = 3;
    /** 广告位类型 4-浮标. */
    public static final int    ADSENSE_TYPE_BUOY                          = 4;
    /** 广告位类型 5-应用墙. */
    public static final int    ADSENSE_TYPE_APP_WALL                      = 5;
    /** 广告位类型 6-开屏. */
    public static final int    ADSENSE_TYPE_OPEN_SCREEN                   = 6;
    /** 广告位类型 7-自定义. */
    public static final int    ADSENSE_TYPE_USER_DEFINED                  = 7;
    /** 广告位类型 8-手动投放. */
    public static final int    ADSENSE_TYPE_MANUAL                        = 8;
    /** 广告位类型 9-SDK投放. */
    public static final int    ADSENSE_TYPE_MATERIAL_SPEC                 = 9;
    /** 广告位类型 0-插屏. */
    public static final String ADSENSE_TYPE_PLAQUE_STR                    = "插屏";
    /** 广告位类型 1-横幅. */
    public static final String ADSENSE_TYPE_STREAMER_BANNER_STR           = "横幅";
    /** 广告位类型 2-信息流. */
    public static final String ADSENSE_TYPE_INFORMATION_STREAM_STR        = "信息流";
    /** 广告位类型 3-banner. */
    public static final String ADSENSE_TYPE_BANNER_STR                    = "banner";
    /** 广告位类型 4-浮标. */
    public static final String ADSENSE_TYPE_BUOY_STR                      = "浮标";
    /** 广告位类型 5-应用墙. */
    public static final String ADSENSE_TYPE_APP_WALL_STR                  = "应用墙";
    /** 广告位类型 6-开屏. */
    public static final String ADSENSE_TYPE_OPEN_SCREEN_STR               = "开屏";
    /** 广告位类型 7-自定义. */
    public static final String ADSENSE_TYPE_USER_DEFINED_STR              = "自定义";
    /** 广告位类型 8-手动投放. */
    public static final String ADSENSE_TYPE_MANUAL_STR                    = "手动投放";
    /** 广告位类型 9-SDK投放. */
    public static final String ADSENSE_TYPE_MATERIAL_SPEC_STR             = "SDK投放";
    /** 开通状态:0-待审核. */
    public static final int    CHECK_STATUS_CHECKING                      = 0;
    /** 开通状态:1-审核通过. */
    public static final int    CHECK_STATUS_PASS                          = 1;
    /** 开通状态:2-审核拒绝. */
    public static final int    CHECK_STATUS_FAIL                          = 2;
    /** 广告位状态:0-关闭. */
    public static final int    ENABLE_STATUS_CLOSE                        = 0;
    /** 广告位状态:1-开启. */
    public static final int    ENABLE_STATUS_OPEN                         = 1;
    /** 广告类型 -信息流-广告位尺寸 0-750*420. */
    public static final int    ADSENSE_TYPE_INFORMATION_FLOW_SIZE_750_420 = 0;
    /** 广告类型 -信息流-广告位尺寸 1-750*180. */
    public static final int    ADSENSE_TYPE_INFORMATION_FLOW_TYPE_750_180 = 1;
    /** 75：42 广告尺寸. */
    public static final String FLOW_TYPE_SIZE_750_420                     = "750*420";
    /** 25：6 广告尺寸. */
    public static final String FLOW_TYPE_SIZE_750_180                     = "750*180";
    /** 类型数量. */
    public static final int    ADSENSE_TYPE_SIZE                          = 9;
    /** 已删除状态. */
    public static final int    IS_DELETE_STATUS                           = 1;
    /** 未删除状态. */
    public static final int    NO_DELETE_STATUS                           = 0;
    /** 轮询投放方式. */
    public static final int    POLLING_PUTWAY                             = 0;
    /** 定时投放方式. */
    public static final int    TIMING_PUTWAY                              = 1;

    /** 活动组-定时投放方式. */
    public static final int    GROUP_PUTWAY                               = 2;
    /** 活动组-比例投放方式. */
    public static final int    RATIO_PUTWAY                               = 3;
    /** 仅投活动算法推荐投放方式. */
    public static final int    CONFIG_ACT_ALGO_PUTWAY                     = 4;

    /** 未冻结 */
    public static final int    NO_FROZEN_STATUS                           = 0;
    /** 已冻结 */
    public static final int    IS_FROZEN_STATUS                           = 1;

    /** 1 图片 */
    public static final int    SCK_PIC                                    = 1;
    /** 2 图文 */
    public static final int    SCK_PIC_CHAR                               = 2;
    /** 3 文字链 */
    public static final int    SCK_CHAR                                   = 3;

    /** gif 启用 */
    public static final int    GIF_ENABLE                                 = 1;
    /** gif关闭 */
    public static final int    GIF_CLOSE                                  = 0;

    /** 广告位显示广告类型 0-互动广告 */
    public static final int    SLOT_ACCESS_TYPE_HD                          = 0;

    /** 广告位显示广告类型 1-展示广告 */
    public static final int    SLOT_ACCESS_TYPE_ZS                          = 1;

    /** 客服按钮开启 */
    public static final int    SERVICE_STATUS_ENABLE                        = 1;

    /** 客服按钮关闭 */
    public static final int    SERVICE_STATUS_DISABLE                       = 0;

    /** 满足客服按钮关闭条件的流量分级标签的名字 **/
    public static final String CLOSE_GRADE_TAG_NAME_THREE_LEVEL = "三级流量";

    public static final String CLOSE_GRADE_TAG_NAME_OVERSEAS = "海外";

    private static final Long MEDIAID = -1L;

    private static final Long APPID = -1L;

    public static final Integer OPEN = 1;
    public static final Integer CLOSE = 0;



    /** 广告位类型 1-弹窗. */
    public static final int    SCENE_TYPE_STREAMER_PLAQUE             = 1;
    /** 广告位类型 2-banner/横幅. */
    public static final int    SCENE_TYPE_STREAMER_BANNER            = 2;
    /** 广告位类型 3-信息流. */
    public static final int    SCENE_TYPE_INFORMATION_STREAM              = 3;
    /** 广告位类型 4-信息流1. */
    public static final int    SCENE_TYPE_INFORMATION_STREAM_ONE              = 4;
    /** 广告位类型 6-浮标. */
    public static final int    SCENE_TYPE_BUOY                          = 6;
    /** 广告位类型 7-应用墙. */
    public static final int    SCENE_TYPE_APP_WALL                      = 7;
    /** 广告位类型 8-开屏. */
    public static final int    SCENE_TYPE_OPEN_SCREEN                   = 8;
    /** 广告位类型 9-自定义场景. */
    public static final int    SCENE_TYPE_USER_DEFINED                  = 9;
    /** 广告位类型 10-原生插屏. */
    public static final int    SCENE_TYPE_MANUAL                        = 10;
    /** 广告位类型 11-icon. */
    public static final int    SCENE_TYPE_ICON                        = 11;
    /** 广告位类型 12-文字链. */
    public static final int    SCENE_TYPE_WORD                        = 12;
    /** 广告位类型 13-悬浮升级. */
    public static final int    SCENE_TYPE_SUSPEND                        = 13;



    /** The Constant serialVersionUID. */
    private static final long  serialVersionUID                           = 8911023809144330642L;

    /** 媒体ID. */
    private Long               appId;

    /** 媒体名称. */
    private String             appName;

    /** 媒体用户ID. */
    private Long               mediaId;

    /** 广告位名称. */
    private String             slotName;

    /** 广告位类型 0-插屏 1-横幅 2-信息流 3-banner 4-浮标 5-应用墙. */
    private Integer            slotType;

    /** 素材规格ID. */
    private Long               slotMsId;

    /** 审核状态:0-待审核;1-审核拒绝;2-审核通过. */
    private Integer            checkStatus;

    /** 广告位状态:0-关闭;1-开启. */
    private Integer            enableStatus;

    /** 主图尺寸 0-600*300 1-600*500 2-640*270 3-960*640 4-800*120. */
    private Integer            pictureSize;

    /** 屏蔽策略ID. */
    private Long               strategyId;

    /** 小图标是否可见. */
    private Boolean            isVisibleOfIco;

    /** 关闭按钮是否可见. */
    private Boolean            isVisibleOfCloseButton;

    /** 手动投放时的活动投放地址. */
    private String             activityUrl;

    /** 手动投放时的活动投放目标地址. */
    private String             activityTargetUrl;

    /** 广告位曝光上限. */
    private Integer            slotExposeLimit;

    /** 活动曝光上限. */
    private Integer            activityExposeLimit;

    /** 删除状态. */
    private Integer            deleteStatus;

    /** 是否拦截返回操作(1:拦截，0:不拦截). */
    private Boolean            isReturn;

    /** 拦截返回操作频次. */
    private Integer            numReturn;

    /** 返回拦截类型(0:返回拦截页面，1:更多福利弹层, 2:再来一次弹层) */
    private Integer           returnType = 0;

    /** 每次拦截返回次数. */
    private Integer            timesReturn;

    /** 推荐位弹层开关(1:开，0:关). */
    private Boolean            isRecommend;

    /** 广告位投放方式 */
    private Integer            activityPutWay;

    /** 冻结状态 */
    private Integer            frozenStatus;

    /** 冻结原因 */
    private String             frozenReason;

    /** 管理端屏蔽策略标签 */
    private Long               managerStrategyId;

    /** 广告位添加备注 **/
    private String             remark;

    /** 广告位备注信息 **/
    private String             remarkImg;

    /** 活动客服开关(1:开，0:关). */
    private Integer            showService;

    //-------------------新增客服按钮的控制以及客服号码-------------//
    /** 客服电话是否自定义(1:自定义，0:默认). */
    private Integer            isServicePhone;

    /**自定义客服电话 */
    private String             servicePhone;

    /** 奖品页客服开关(1:开，0:关). */
    private Integer            isPrizeShowService;

    /** 奖品页客服电话是否自定义(1:自定义，0:默认). */
    private Integer            isPrizeServicePhone;

    /**自定义奖品页客服电话 */
    private String             prizeServicePhone;


    /** 活动客服样式ID */
    private Long               showServiceId;

    /** 手动投放素材类型 */
    private Integer            sckType;

    /** gif开启状态 */
    private Integer            gifStatus;

    /** 视频素材开启状态 0 禁用视频素材 1 启用视频素材 */
    private Integer            videoStatus;

    /** 自动填充 */
    private Integer            autoFill;

    /** 广告位浮标插件配置信息 */
    private PlugBuoyConfigDto  plugBuoyConfigDto;

    /** 激励开关(0-关闭，1-默认，2-自定义) */
    private Integer incentiveSwitch;

    /** 接入广告类型 0-互动广告 1-展示广告 2-原生互动广告 */
    private Integer slotAccessType;

    /** 接入类型 0-默认方式 1-jssdk 2-sdk */
    private Integer joinInType;

    /** 激励活动内容配置 */
    private IncentiveContentDto incentiveContentDto;

    /** 开启激励配置时是否返回拦截红包雨，1：是，0：否--不触发增值 */
    private Integer incentiveIntercept;

    /** 广告位是否开启地域定向，默认0：关闭，1：打开 */
    private Integer slotRegionStatus;

    /**广告位白名单开启状态 0-关闭 1-开启*/
    private Integer openWihteList;

    /** 广告位素材标签屏蔽开关 */
    private int slotShieldMaterialFlag;

    /**
     *   广告角标    tinyint  默认关闭0  , 1开启
     */
    private Integer isShowAd = 0;

    /**
     * 承办声明开关   默认为0，1开启
     */
    private Integer undertakeStateSwitch = 0;

    /**
     * 承办声明内容
     */
    private String undertakeStateContext ;

    /**
     * 承办声明内容
     */
    private String undertakeStateContextFormat ;

    /** 广告位素材审核开关  0-关闭 1-开启*/
    private Integer sckCheckSwitch;

    /** 广告位素材算法PV分流开关开关，0：关闭，1：开启 */
    private Integer scAlgoStatus;
    /** 广告位素材算法PV分流百分比（整数） */
    private Integer scAlgoRatio;
    /** 广告位素材算法UV分流是否仅用gif 0：全部 1：仅使用gif */
    private Integer scAlgoGifStatus;
    /** 素材算法API接入方式占比 **/
    private Integer apiAlgoRate;

    /** 素材随机投放方式开关（整数） */
    private Integer scRandomStatus;
    /** 素材随机投放方式占比 **/
    private Integer scRandomRate;

    /**同步白名单到流量策略标识:0-不同步,1-同步**/
    private Integer isSyncWhiteList;

    /**
     * 是否开启标题算法，默认0不开启，1开启
     */
    private Integer isAlgoTitle;
    /**
     * 标题算法占比，大于等于100就全走
     */
    private Integer algoTitleRate;

    /**
     * 广告位计费类型(0:eCPM 1:uv收益导向)
     */
    private Integer feeMark;

    /** 详情页客服电话按钮(1:开，0:关). */
    private Integer showDetailPhone;

    //投放场景 1:'插屏',2:'banner/横幅',3:'信息流',6:'浮标',7:'应用墙',8:'开屏',9:'自定义场景',10:'原生插屏'
    private Integer sceneType;

    //投放场景为：原生插屏、自定义场景时传参素材类型
    private String elements;

    /**
     * 算法使用挑选素材开关，0：关闭，1：开启
     */
    private Integer algoSelectStatus;

    /** 是否开启奖品算法，默认0不开启，1开启 */
    private Integer isAlgoPrize;

    /** 奖品算法占比，大于等于100就全走 */
    private Integer algoPrizeRate;

    private Integer supportDownGrade;

    /** 广告位开启黑名单 */
    private Integer openBlackList;

    /** 0-同步到流量策略,1-同步到全局 */
    private Integer isSyncBlackList;

    /** 1-活动弹层关闭拦截开关开启，0-活动弹层关闭拦截开关关闭 */
    private Integer isLayerCloseIntercept;

    /** 是否对广告位上活动进行过操作：0未操作,1已操作 */
    private Integer operateStatus;

    /** 操作的日期 */
    private Date operateCurDate;

    /** 活动素材定制状态：0不定制,1有定制 */
    private Integer actSckStatus;

    public Integer getIsLayerCloseIntercept() {
        return isLayerCloseIntercept;
    }

    public void setIsLayerCloseIntercept(Integer isLayerCloseIntercept) {
        this.isLayerCloseIntercept = isLayerCloseIntercept;
    }

    /** 素材类型（1:单图 2:组图） */
    private Integer materialType;

    /** 客服按钮 默认开（1-开，0-关） */
    private Integer orderServiceSwitch;

    /** 是否只支持svga格式素材。0-关闭，1-开启 */
    private Integer bindSvga;

    /** 唤醒广告是否开启 0-关闭 1-开启 */
    private Integer deeplinkStatus;

    /**
     * 广告位链接宏替换开关。0-关，1-开
     */
    private Integer tuParamStatus;
    /** 唤醒广告蒙层是否开启 0-关闭 1-开启(默认) */
    private Integer deeplinkLayer;

    // 信息流规格模板类型 0=自定义、1=上文下图、2=左文右图、3=左图右文、4=三图
    private Integer templateType;
    /**
     * 可投广告位列表: 0-关闭 1-开启
     */
    private Integer openAvailableAdvertisementsList;

    /**
     * 券次序定制广告开关：0=关闭、1=开启
     */
    private Integer advertOrderCustomStatus;
    /**
     * 落地页链接审核开关 0-关闭 1-开启
     */
    private Integer isLandPageAudit;
    /**
     * 广告位用途说明
     */
    private String purposeExplain;

    /**
     * 不死链接id
     */
    private Long undeadLinkId;

    /**
     * 不死链接地址
     */
    private String undeadLink;

    /**
     * 规则背景图
     */
    @ApiModelProperty(value = "规则背景图")
    private String ruleBackground;

    /**
     * 是否开启UA维度活动定向投放 0-否 1-是
     */
    private Integer isUaTargetDelivery;

    public Integer getIsUaTargetDelivery() {
        return isUaTargetDelivery;
    }

    public void setIsUaTargetDelivery(Integer isUaTargetDelivery) {
        this.isUaTargetDelivery = isUaTargetDelivery;
    }

    public Long getUndeadLinkId() {
        return undeadLinkId;
    }

    public void setUndeadLinkId(Long undeadLinkId) {
        this.undeadLinkId = undeadLinkId;
    }

    public String getUndeadLink() {
        return undeadLink;
    }

    public void setUndeadLink(String undeadLink) {
        this.undeadLink = undeadLink;
    }

    public String getPurposeExplain() {
        return purposeExplain;
    }

    public void setPurposeExplain(String purposeExplain) {
        this.purposeExplain = purposeExplain;
    }

    public Integer getIsLandPageAudit() {
        return isLandPageAudit;
    }

    public void setIsLandPageAudit(Integer isLandPageAudit) {
        this.isLandPageAudit = isLandPageAudit;
    }

    /**
     * 和源广告位ID是否同组标识，为1表示同组，null或者其他表示非同组
     */
    private Integer sameGroupWithSourceSlotId;

    public Integer getOpenAvailableAdvertisementsList() {
        return openAvailableAdvertisementsList;
    }

    public void setOpenAvailableAdvertisementsList(Integer openAvailableAdvertisementsList) {
        this.openAvailableAdvertisementsList = openAvailableAdvertisementsList;
    }

    public Integer getIsAlgoPrize() {
        return isAlgoPrize;
    }

    public void setIsAlgoPrize(Integer isAlgoPrize) {
        this.isAlgoPrize = isAlgoPrize;
    }

    public Integer getAlgoPrizeRate() {
        return algoPrizeRate;
    }

    public void setAlgoPrizeRate(Integer algoPrizeRate) {
        this.algoPrizeRate = algoPrizeRate;
    }

    public Integer getFeeMark() {
        return feeMark;
    }

    public void setFeeMark(final Integer feeMark) {
        this.feeMark = feeMark;
    }

    public Integer getIsAlgoTitle() {
        return isAlgoTitle;
    }

    public void setIsAlgoTitle(Integer isAlgoTitle) {
        this.isAlgoTitle = isAlgoTitle;
    }

    public Integer getAlgoTitleRate() {
        return algoTitleRate;
    }

    public void setAlgoTitleRate(Integer algoTitleRate) {
        this.algoTitleRate = algoTitleRate;
    }

    public Integer getShowDetailPhone() {
        return showDetailPhone;
    }

    public void setShowDetailPhone(final Integer showDetailPhone) {
        this.showDetailPhone = showDetailPhone;
    }

    public Integer getSupportDownGrade() {
        return supportDownGrade;
    }

    public void setSupportDownGrade(Integer supportDownGrade) {
        this.supportDownGrade = supportDownGrade;
    }

    /**
     * slotNumToName:(获取广告位类型名称通过广告类型编号). <br/>
     *
     * @param slotType the slot type
     * @return the slot type name by slot type
     * @since JDK 1.6
     */
    public static String getSlotTypeNameBySlotType(int slotType) {// NOSONAR
        String slotTypeName = "";
        switch (slotType) {
            case ADSENSE_TYPE_PLAQUE:
                slotTypeName = "插屏";
                break;
            case ADSENSE_TYPE_STREAMER_BANNER:
                slotTypeName = "横幅";
                break;
            case ADSENSE_TYPE_INFORMATION_STREAM:
                slotTypeName = "信息流";
                break;
            case ADSENSE_TYPE_BANNER:
                slotTypeName = "banner";
                break;
            case ADSENSE_TYPE_BUOY:
                slotTypeName = "浮标";
                break;
            case ADSENSE_TYPE_APP_WALL:
                slotTypeName = "应用墙";
                break;
            case ADSENSE_TYPE_OPEN_SCREEN:
                slotTypeName = "开屏";
                break;
            case ADSENSE_TYPE_USER_DEFINED:
                slotTypeName = "自定义";
                break;
            case ADSENSE_TYPE_MANUAL:
                slotTypeName = "手动投放";
                break;
            case ADSENSE_TYPE_MATERIAL_SPEC:
                slotTypeName = "SDK投放";
                break;
            default:
                break;
        }
        return slotTypeName;
    }

    /**
     * 根据广告位类型获取枚举值
     * @return the slot type name by slot type
     * @since JDK 1.6
     */
    public static String getSceneTypeNameBySceneType(int sceneType) {
        String sceneTypeName = "";
        switch (sceneType) {
            case SCENE_TYPE_STREAMER_PLAQUE:
                sceneTypeName = "弹窗";
                break;
            case SCENE_TYPE_STREAMER_BANNER:
                sceneTypeName = "banner/横幅";
                break;
            case SCENE_TYPE_INFORMATION_STREAM:
                sceneTypeName = "信息流";
                break;
            case SCENE_TYPE_INFORMATION_STREAM_ONE:
                sceneTypeName = "信息流1";
                break;
            case SCENE_TYPE_BUOY:
                sceneTypeName = "浮标";
                break;
            case SCENE_TYPE_APP_WALL:
                sceneTypeName = "应用墙";
                break;
            case SCENE_TYPE_OPEN_SCREEN:
                sceneTypeName = "开屏";
                break;
            case SCENE_TYPE_USER_DEFINED:
                sceneTypeName = "自定义场景";
                break;
            case SCENE_TYPE_MANUAL:
                sceneTypeName = "原生插屏";
                break;
            case SCENE_TYPE_ICON:
                sceneTypeName = "icon";
                break;
            case SCENE_TYPE_WORD:
                sceneTypeName = "文字链";
                break;
            case SCENE_TYPE_SUSPEND:
                sceneTypeName = "悬浮升级";
                break;
            default:
                break;
        }
        return sceneTypeName;
    }

    public Integer getOpenWihteList() {
        return openWihteList;
    }

    public void setOpenWihteList(Integer openWihteList) {
        this.openWihteList = openWihteList;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRemarkImg() {
        return remarkImg;
    }

    public void setRemarkImg(String remarkImg) {
        this.remarkImg = remarkImg;
    }

    public Integer getFrozenStatus() {
        return frozenStatus;
    }

    public void setFrozenStatus(Integer frozenStatus) {
        this.frozenStatus = frozenStatus;
    }

    public String getFrozenReason() {
        return frozenReason;
    }

    public void setFrozenReason(String frozenReason) {
        this.frozenReason = frozenReason;
    }

    /**
     * Checks if is visible of ico.
     *
     * @return true, if checks if is visible of ico
     */
    public Boolean isVisibleOfIco() {
        return isVisibleOfIco;
    }

    /**
     * Sets the visible of ico.
     *
     * @param isVisibleOfIco the visible of ico
     */
    public void setVisibleOfIco(Boolean isVisibleOfIco) {
        this.isVisibleOfIco = isVisibleOfIco;
    }

    /**
     * Checks if is visible of close button.
     *
     * @return true, if checks if is visible of close button
     */
    public Boolean isVisibleOfCloseButton() {
        return isVisibleOfCloseButton;
    }

    /**
     * Sets the visible of close button.
     *
     * @param isVisibleOfCloseButton the visible of close button
     */
    public void setVisibleOfCloseButton(Boolean isVisibleOfCloseButton) {
        this.isVisibleOfCloseButton = isVisibleOfCloseButton;
    }

    /**
     * Gets the app id.
     *
     * @return the app id
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * Sets the app id.
     *
     * @param appId the app id
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * Gets the media id.
     *
     * @return the media id
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * Sets the media id.
     *
     * @param mediaId the media id
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    /**
     * Gets the check status.
     *
     * @return the check status
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * Sets the check status.
     *
     * @param checkStatus the check status
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    /**
     * Gets the slot name.
     *
     * @return the slot name
     */
    public String getSlotName() {
        return slotName;
    }

    /**
     * Sets the slot name.
     *
     * @param slotName the slot name
     */
    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    /**
     * Gets the slot type.
     *
     * @return the slot type
     */
    public Integer getSlotType() {
        return slotType;
    }

    /**
     * Sets the slot type.
     *
     * @param slotType the slot type
     */
    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }

    /**
     * Gets the enable status.
     *
     * @return the enable status
     */
    public Integer getEnableStatus() {
        return enableStatus;
    }

    /**
     * Sets the enable status.
     *
     * @param enableStatus the enable status
     */
    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    /**
     * Gets the picture size.
     *
     * @return the picture size
     */
    public Integer getPictureSize() {
        return pictureSize;
    }

    /**
     * Sets the picture size.
     *
     * @param pictureSize the picture size
     */
    public void setPictureSize(Integer pictureSize) {
        this.pictureSize = pictureSize;
    }

    /**
     * Gets the strategy id.
     *
     * @return the strategy id
     */
    public Long getStrategyId() {
        return strategyId;
    }

    /**
     * Sets the strategy id.
     *
     * @param strategyId the strategy id
     */
    public void setStrategyId(Long strategyId) {
        this.strategyId = strategyId;
    }

    /**
     * Gets the activity url.
     *
     * @return the activity url
     */
    public String getActivityUrl() {
        return activityUrl;
    }

    /**
     * Sets the activity url.
     *
     * @param activityUrl the activity url
     */
    public void setActivityUrl(String activityUrl) {
        this.activityUrl = activityUrl;
    }

    /**
     * Gets the activity target url.
     *
     * @return the activity target url
     */
    public String getActivityTargetUrl() {
        return activityTargetUrl;
    }

    /**
     * Sets the activity target url.
     *
     * @param activityTargetUrl the activity target url
     */
    public void setActivityTargetUrl(String activityTargetUrl) {
        this.activityTargetUrl = activityTargetUrl;
    }

    /**
     * Gets the slot expose limit.
     *
     * @return the slot expose limit
     */
    public Integer getSlotExposeLimit() {
        return slotExposeLimit;
    }

    /**
     * Sets the slot expose limit.
     *
     * @param slotExposeLimit the slot expose limit
     */
    public void setSlotExposeLimit(Integer slotExposeLimit) {
        this.slotExposeLimit = slotExposeLimit;
    }

    /**
     * Gets the activity expose limit.
     *
     * @return the activity expose limit
     */
    public Integer getActivityExposeLimit() {
        return activityExposeLimit;
    }

    /**
     * Sets the activity expose limit.
     *
     * @param activityExposeLimit the activity expose limit
     */
    public void setActivityExposeLimit(Integer activityExposeLimit) {
        this.activityExposeLimit = activityExposeLimit;
    }

    /**
     * Gets the delete status.
     *
     * @return the delete status
     */
    public Integer getDeleteStatus() {
        return deleteStatus;
    }

    /**
     * Sets the delete status.
     *
     * @param deleteStatus the delete status
     */
    public void setDeleteStatus(Integer deleteStatus) {
        this.deleteStatus = deleteStatus;
    }

    /**
     * Gets the slot ms id.
     *
     * @return the slot ms id
     */
    public Long getSlotMsId() {
        return slotMsId;
    }

    /**
     * Sets the slot ms id.
     *
     * @param slotMsId the slot ms id
     */
    public void setSlotMsId(Long slotMsId) {
        this.slotMsId = slotMsId;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public Boolean getIsReturn() {
        return isReturn;
    }

    public void setIsReturn(Boolean isReturn) {
        this.isReturn = isReturn;
    }

    public Integer getNumReturn() {
        return numReturn;
    }

    public void setNumReturn(Integer numReturn) {
        this.numReturn = numReturn;
    }

    public Integer getTimesReturn() {
        return timesReturn;
    }

    public void setTimesReturn(Integer timesReturn) {
        this.timesReturn = timesReturn;
    }

    public Boolean getIsRecommend() {
        return isRecommend;
    }

    public void setIsRecommend(Boolean isRecommend) {
        this.isRecommend = isRecommend;
    }

    public Integer getActivityPutWay() {
        return activityPutWay;
    }

    public void setActivityPutWay(Integer activityPutWay) {
        this.activityPutWay = activityPutWay;
    }

    public Long getManagerStrategyId() {
        return managerStrategyId;
    }

    public void setManagerStrategyId(Long managerStrategyId) {
        this.managerStrategyId = managerStrategyId;
    }

    public Integer getShowService() {
        return showService;
    }

    public void setShowService(Integer showService) {
        this.showService = showService;
    }

    public Long getShowServiceId() {
        return showServiceId;
    }

    public void setShowServiceId(Long showServiceId) {
        this.showServiceId = showServiceId;
    }

    public PlugBuoyConfigDto getPlugBuoyConfigDto() {
        return plugBuoyConfigDto;
    }

    public void setPlugBuoyConfigDto(PlugBuoyConfigDto plugBuoyConfigDto) {
        this.plugBuoyConfigDto = plugBuoyConfigDto;
    }

    public Integer getSckType() {
        return sckType;
    }

    public void setSckType(Integer sckType) {
        this.sckType = sckType;
    }

    public Integer getGifStatus() {
        return gifStatus;
    }

    public void setGifStatus(Integer gifStatus) {
        this.gifStatus = gifStatus;
    }

    public Integer getVideoStatus() {
        return videoStatus;
    }

    public void setVideoStatus(Integer videoStatus) {
        this.videoStatus = videoStatus;
    }

    public Integer getAutoFill() {
        return autoFill;
    }

    public void setAutoFill(Integer autoFill) {
        this.autoFill = autoFill;
    }

    public Integer getIncentiveSwitch() {
        return incentiveSwitch;
    }

    public void setIncentiveSwitch(Integer incentiveSwitch) {
        this.incentiveSwitch = incentiveSwitch;
    }

    public Integer getSlotAccessType() {
        return slotAccessType;
    }

    public void setSlotAccessType(Integer slotAccessType) {
        this.slotAccessType = slotAccessType;
    }

    public IncentiveContentDto getIncentiveContentDto() {
        return incentiveContentDto;
    }

    public void setIncentiveContentDto(IncentiveContentDto incentiveContentDto) {
        this.incentiveContentDto = incentiveContentDto;
    }

    public Integer getIncentiveIntercept() {
        return incentiveIntercept;
    }

    public void setIncentiveIntercept(Integer incentiveIntercept) {
        this.incentiveIntercept = incentiveIntercept;
    }

    public Integer getSlotRegionStatus() {
        return slotRegionStatus;
    }

    public void setSlotRegionStatus(Integer slotRegionStatus) {
        this.slotRegionStatus = slotRegionStatus;
    }

    public Integer getReturnType() {
        return returnType;
    }

    public void setReturnType(Integer returnType) {
        this.returnType = returnType;
    }

    public int getSlotShieldMaterialFlag() {
        return slotShieldMaterialFlag;
    }

    public void setSlotShieldMaterialFlag(int slotShieldMaterialFlag) {
        this.slotShieldMaterialFlag = slotShieldMaterialFlag;
    }

    public Integer getSckCheckSwitch() {
        return sckCheckSwitch;
    }

    public void setSckCheckSwitch(Integer sckCheckSwitch) {
        this.sckCheckSwitch = sckCheckSwitch;
    }

    public Integer getJoinInType() {
        return joinInType;
    }

    public void setJoinInType(final Integer joinInType) {
        this.joinInType = joinInType;
    }

    public Integer getIsShowAd() {
        return isShowAd;
    }

    public void setIsShowAd(Integer isShowAd) {
        this.isShowAd = isShowAd;
    }

    public Integer getUndertakeStateSwitch() {
        return undertakeStateSwitch;
    }

    public void setUndertakeStateSwitch(Integer undertakeStateSwitch) {
        this.undertakeStateSwitch = undertakeStateSwitch;
    }

    public String getUndertakeStateContext() {
        return undertakeStateContext;
    }

    public void setUndertakeStateContext(String undertakeStateContext) {
        this.undertakeStateContext = undertakeStateContext;
    }

    public Integer getScRandomStatus() {
        return scRandomStatus;
    }

    public void setScRandomStatus(Integer scRandomStatus) {
        this.scRandomStatus = scRandomStatus;
    }

    public Integer getScRandomRate() {
        return scRandomRate;
    }

    public void setScRandomRate(Integer scRandomRate) {
        this.scRandomRate = scRandomRate;
    }

    /**
     * 构造虚拟广告位
     * @param slotDto
     * @return
     */
    public static SlotDto buildVirtualSlot(SlotDto slotDto){
        slotDto.setMediaId(MEDIAID);
        slotDto.setAppId(APPID);
        slotDto.setSlotType(SlotDto.ADSENSE_TYPE_MANUAL);
        slotDto.setCheckStatus(0);
        slotDto.setEnableStatus(0);
        slotDto.setGifStatus(1);
        slotDto.setVideoStatus(0);
        if(slotDto.getReturnType() ==null){
            slotDto.setReturnType(0);
        }
        return slotDto;
    }

    public Integer getScAlgoStatus() {
        return scAlgoStatus;
    }

    public void setScAlgoStatus(Integer scAlgoStatus) {
        this.scAlgoStatus = scAlgoStatus;
    }

    public Integer getScAlgoRatio() {
        return scAlgoRatio;
    }

    public void setScAlgoRatio(Integer scAlgoRatio) {
        this.scAlgoRatio = scAlgoRatio;
    }

    public Integer getApiAlgoRate() {
        return apiAlgoRate;
    }

    public void setApiAlgoRate(Integer apiAlgoRate) {
        this.apiAlgoRate = apiAlgoRate;
    }

    public Integer getIsSyncWhiteList() {
        return isSyncWhiteList;
    }

    public void setIsSyncWhiteList(Integer isSyncWhiteList) {
        this.isSyncWhiteList = isSyncWhiteList;
    }

    public Integer getAlgoSelectStatus() {
        return algoSelectStatus;
    }

    public void setAlgoSelectStatus(Integer algoSelectStatus) {
        this.algoSelectStatus = algoSelectStatus;
    }

    public Integer getSceneType() {
        return sceneType;
    }

    public void setSceneType(Integer sceneType) {
        this.sceneType = sceneType;
    }

    public String getElements() {
        return elements;
    }

    public void setElements(String elements) {
        this.elements = elements;
    }

    public Integer getOpenBlackList() {
        return openBlackList;
    }

    public void setOpenBlackList(final Integer openBlackList) {
        this.openBlackList = openBlackList;
    }

    public Integer getIsSyncBlackList() {
        return isSyncBlackList;
    }

    public void setIsSyncBlackList(final Integer isSyncBlackList) {
        this.isSyncBlackList = isSyncBlackList;
    }

    public Integer getIsServicePhone() {
        return isServicePhone;
    }

    public void setIsServicePhone(Integer isServicePhone) {
        this.isServicePhone = isServicePhone;
    }

    public String getServicePhone() {
        return servicePhone;
    }

    public void setServicePhone(String servicePhone) {
        this.servicePhone = servicePhone;
    }

    public Integer getIsPrizeShowService() {
        return isPrizeShowService;
    }

    public void setIsPrizeShowService(Integer isPrizeShowService) {
        this.isPrizeShowService = isPrizeShowService;
    }

    public Integer getIsPrizeServicePhone() {
        return isPrizeServicePhone;
    }

    public void setIsPrizeServicePhone(Integer isPrizeServicePhone) {
        this.isPrizeServicePhone = isPrizeServicePhone;
    }

    public String getPrizeServicePhone() {
        return prizeServicePhone;
    }

    public void setPrizeServicePhone(String prizeServicePhone) {
        this.prizeServicePhone = prizeServicePhone;
    }

    public Integer getMaterialType() {
        return materialType;
    }

    public void setMaterialType(Integer materialType) {
        this.materialType = materialType;
    }

    public Integer getOrderServiceSwitch() {
        return orderServiceSwitch;
    }

    public void setOrderServiceSwitch(Integer orderServiceSwitch) {
        this.orderServiceSwitch = orderServiceSwitch;
    }

    public Integer getOperateStatus() {
        return operateStatus;
    }

    public void setOperateStatus(Integer operateStatus) {
        this.operateStatus = operateStatus;
    }

    public Date getOperateCurDate() {
        return operateCurDate;
    }

    public void setOperateCurDate(Date operateCurDate) {
        this.operateCurDate = operateCurDate;
    }

    public Integer getActSckStatus() {
        return actSckStatus;
    }

    public void setActSckStatus(Integer actSckStatus) {
        this.actSckStatus = actSckStatus;
    }

    public Integer getBindSvga() {
        return bindSvga;
    }

    public void setBindSvga(Integer bindSvga) {
        this.bindSvga = bindSvga;
    }

    public Integer getDeeplinkStatus() {
        return deeplinkStatus;
    }

    public void setDeeplinkStatus(Integer deeplinkStatus) {
        this.deeplinkStatus = deeplinkStatus;
    }

    public Integer getTuParamStatus() {
        return tuParamStatus;
    }

    public void setTuParamStatus(Integer tuParamStatus) {
        this.tuParamStatus = tuParamStatus;

    }
    public Integer getDeeplinkLayer() {
        return deeplinkLayer;
    }

    public void setDeeplinkLayer(Integer deeplinkLayer) {
        this.deeplinkLayer = deeplinkLayer;
    }

    public Integer getScAlgoGifStatus() {
        return scAlgoGifStatus;
    }

    public void setScAlgoGifStatus(Integer scAlgoGifStatus) {
        this.scAlgoGifStatus = scAlgoGifStatus;
    }

    public Integer getTemplateType() {
        return templateType;
    }

    public void setTemplateType(Integer templateType) {
        this.templateType = templateType;
    }

    public String getUndertakeStateContextFormat() {
        return undertakeStateContextFormat;
    }

    public void setUndertakeStateContextFormat(String undertakeStateContextFormat) {
        this.undertakeStateContextFormat = undertakeStateContextFormat;
    }

    public Integer getAdvertOrderCustomStatus() {
        return advertOrderCustomStatus;
    }

    public void setAdvertOrderCustomStatus(Integer advertOrderCustomStatus) {
        this.advertOrderCustomStatus = advertOrderCustomStatus;
    }

    public Integer getSameGroupWithSourceSlotId() {
        return sameGroupWithSourceSlotId;
    }

    public void setSameGroupWithSourceSlotId(Integer sameGroupWithSourceSlotId) {
        this.sameGroupWithSourceSlotId = sameGroupWithSourceSlotId;
    }

    public String getRuleBackground() {
        return ruleBackground;
    }

    public void setRuleBackground(String ruleBackground) {
        this.ruleBackground = ruleBackground;
    }
}
