/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.constant;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum AgentSettlementTypeEnum {
    HZ_AGENT((byte)0, "\u676d\u63a8\u4ee3\u7406\u7ed3\u7b97\u5355"),
    HEGS_AGENT((byte)1, "\u970d\u63a8\u4ee3\u7406\u7ed3\u7b97\u5355"),
    HCDJ_AGENT((byte)2, "\u5151\u6377\u4ee3\u7406\u7ed3\u7b97\u5355"),
    HZ_TO_HEGS_AGENT((byte)3, "\u676d\u63a8\u7eb3\u5165\u970d\u63a8\u4ee3\u7406\u7ed3\u7b97\u5355"),
    HZ_HEGS_TO_HCDJ_AGENT((byte)4, "\u676d\u63a8\u548c\u970d\u63a8\u7eb3\u5165\u5151\u6377\u4ee3\u7406\u7ed3\u7b97\u5355"),
    HZ_HCDJ_TO_HEGS_AGENT((byte)5, "\u676d\u63a8\u548c\u5151\u6377\u7eb3\u5165\u970d\u63a8\u4ee3\u7406\u7ed3\u7b97\u5355"),
    HZ_TO_HCDJ_AGENT((byte)6, "\u676d\u63a8\u7eb3\u5165\u5151\u6377\u4ee3\u7406\u7ed3\u7b97\u5355"),
    HEGS_TO_HZ_AGENT((byte)7, "\u970d\u63a8\u7eb3\u5165\u676d\u63a8\u4ee3\u7406\u7ed3\u7b97\u5355"),
    HCDJ_TO_HZ_AGENT((byte)8, "\u5151\u6377\u7eb3\u5165\u676d\u63a8\u4ee3\u7406\u7ed3\u7b97\u5355"),
    HZ_OVERALLOC_AGENT((byte)9, "\u676d\u63a8\u4ee3\u7406\u7ed3\u7b97\u5355(\u8d85\u914d)"),
    HEGS_OVERALLOC_AGENT((byte)10, "\u970d\u63a8\u4ee3\u7406\u7ed3\u7b97\u5355(\u8d85\u914d)"),
    HCDJ_OVERALLOC_AGENT((byte)11, "\u5151\u6377\u4ee3\u7406\u7ed3\u7b97\u5355(\u8d85\u914d)"),
    DUITUI_OVERALLOC_AGENT((byte)12, "\u5151\u63a8\u4ee3\u7406\u7ed3\u7b97\u5355(\u8d85\u914d)"),
    HZ_TO_DUITUI_AGENT((byte)13, "\u676d\u63a8\u7eb3\u5165\u5151\u63a8\u4ee3\u7406\u7ed3\u7b97\u5355"),
    HEGS_TO_DUITUI_AGENT((byte)14, "\u970d\u63a8\u7eb3\u5165\u5151\u63a8\u4ee3\u7406\u7ed3\u7b97\u5355"),
    DUITUI_TO_HZ_AGENT((byte)15, "\u5151\u63a8\u7eb3\u5165\u676d\u63a8\u4ee3\u7406\u7ed3\u7b97\u5355"),
    HZ_HEGS_TO_DUITUI_AGENT((byte)16, "\u676d\u63a8\u548c\u970d\u63a8\u7eb3\u5165\u5151\u63a8\u4ee3\u7406\u7ed3\u7b97\u5355"),
    HZ_DUITUI_TO_HEGS_AGENT((byte)17, "\u676d\u63a8\u548c\u5151\u63a8\u7eb3\u5165\u970d\u63a8\u4ee3\u7406\u7ed3\u7b97\u5355");

    private Byte type;
    private String desc;
    public static final Map<Byte, String> AGENT_COMPANY_MAP;
    public static final Map<Byte, AgentSettlementTypeEnum> AGENT_COMPANYENUM_MAP;
    public static final List<Byte> hegsList;
    public static final List<Byte> hcdjList;
    public static final Set<Byte> DUITUI_TYPE_LIST;

    private AgentSettlementTypeEnum(Byte type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Byte getType() {
        return this.type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static String getCompanyName(Integer type) {
        if (hegsList.contains(type)) {
            return "\u970d\u63a8\u4ee3\u7406\u7ed3\u7b97\u5355";
        }
        if (hcdjList.contains(type)) {
            return "\u5151\u6377\u4ee3\u7406\u7ed3\u7b97\u5355";
        }
        if (DUITUI_TYPE_LIST.contains(type)) {
            return "\u5151\u63a8\u4ee3\u7406\u7ed3\u7b97\u5355";
        }
        return "\u676d\u63a8\u4ee3\u7406\u7ed3\u7b97\u5355";
    }

    public static Byte getSettlementType(Byte type) {
        if (hegsList.contains(type)) {
            return AgentSettlementTypeEnum.HEGS_AGENT.type;
        }
        if (hcdjList.contains(type)) {
            return AgentSettlementTypeEnum.HCDJ_AGENT.type;
        }
        return AgentSettlementTypeEnum.HZ_AGENT.type;
    }

    static {
        hegsList = Lists.newArrayList((Object[])new Byte[]{AgentSettlementTypeEnum.HEGS_AGENT.type, AgentSettlementTypeEnum.HZ_TO_HEGS_AGENT.type, AgentSettlementTypeEnum.HZ_HCDJ_TO_HEGS_AGENT.type, AgentSettlementTypeEnum.HEGS_OVERALLOC_AGENT.type});
        hcdjList = Lists.newArrayList((Object[])new Byte[]{AgentSettlementTypeEnum.HCDJ_AGENT.type, AgentSettlementTypeEnum.HZ_HEGS_TO_HCDJ_AGENT.type, AgentSettlementTypeEnum.HZ_TO_HCDJ_AGENT.type, AgentSettlementTypeEnum.HCDJ_OVERALLOC_AGENT.type});
        DUITUI_TYPE_LIST = Sets.newHashSet((Object[])new Byte[]{AgentSettlementTypeEnum.HZ_TO_DUITUI_AGENT.type, AgentSettlementTypeEnum.HEGS_TO_DUITUI_AGENT.type, AgentSettlementTypeEnum.HZ_HEGS_TO_DUITUI_AGENT.type, AgentSettlementTypeEnum.DUITUI_OVERALLOC_AGENT.type});
        HashMap<Byte, Object> temp = new HashMap<Byte, Object>(AgentSettlementTypeEnum.values().length, 1.0f);
        for (AgentSettlementTypeEnum tag : AgentSettlementTypeEnum.values()) {
            temp.put(tag.getType(), tag.getDesc());
        }
        AGENT_COMPANY_MAP = Collections.unmodifiableMap(temp);
        temp = new HashMap(AgentSettlementTypeEnum.values().length, 1.0f);
        for (AgentSettlementTypeEnum tag : AgentSettlementTypeEnum.values()) {
            temp.put(tag.getType(), (Object)tag);
        }
        AGENT_COMPANYENUM_MAP = Collections.unmodifiableMap(temp);
    }
}

