package cn.com.duiba.tuia.ssp.center.api.econtract.dto.bestsign.contract;

/**
 * 〈一句话功能简述〉<br>
 * Description: 用模版变量的手动签请求对象
 *
 * @author hillchen
 * @create 2019/1/18 17:15
 */
public class SendByTemplateReq {
    /**
     * 合同编号
     */
    private String contractId;

    /**
     * 签署用户id:指定给哪个用户看
     */
    private String signer;

    /**
     * 预览图片清晰度，枚举值：96-低清（默认），120-普清，160-高清，240-超清
     */
    private String dpi;

    /**
     * 签署链接的过期时间，unix时间戳
     */
    private String expireTime;

    /**
     * 模版ID
     */
    private String tid;

    /**
     * 模板的变量名称，针对“模版”中的签署字段的变量名称，可以填多个
     */
    private String varNames;

    /**
     * 在有指定signaturePOSTion参数的情况下，是否允许拖动签名位置。取值1/0。（0：不允许，1：允许）
     */
    private String isAllowChangeSignaturePosition;

    /**
     * 手动签署时，当用户签署完成后，签署页面指定回跳的页面地址，如果没填此参数则签署完成后跳转到合同预览页面
     */
    private String returnUrl;

    /**
     * 手动签署时指定接收手机验证码的手机号，如果需要采用手动签署页面校验短信验证码，则此项必填
     */
    private String vcodeMobile;

    /**
     * 手动签署时是否手绘签名。取值0/1/2。
     * 0点击签名图片不会触发手写面板（禁止手写）。
     * 1点击签名图片能触发手写面板（既可手写也可使用默认签名）。
     * 2强制必须手绘签名（只能手写不允许使用默认签名
     */
    private String isDrawSignatureImage;

    /**
     * 签名/印章图片。取值default或者指定的印章名称。（手动签都用默认的）
     */
    private String signatureImageName;

    /**
     * 此处有配置则签署推送消息优先使用此配置，如果此处没有配置，则取开发者统一配置的异步推送地址
     */
    private String pushUrl;

    /**
     * 手动签的版本，默认为2，枚举值：
     * 2-v2版本,
     * 3-v3版本，UI优化，移动端手绘面板自动横屏
     */
    private String version;

    /**
     * 枚举值0/1，默认为0
     * 1-手写面板及签名图片上显示手写签名操作的时间
     * 0-不显示该时间
     */
    private String isShowHandwrittenTime;

    /**
     * 是否使用刷脸签。
     * 1-刷脸签，使用刷脸校验；
     * 0或其他-非刷脸签，使用短信校验或无校验；
     */
    private String isFaceAuth;

    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public String getSigner() {
        return signer;
    }

    public void setSigner(String signer) {
        this.signer = signer;
    }

    public String getDpi() {
        return dpi;
    }

    public void setDpi(String dpi) {
        this.dpi = dpi;
    }

    public String getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(String expireTime) {
        this.expireTime = expireTime;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getVarNames() {
        return varNames;
    }

    public void setVarNames(String varNames) {
        this.varNames = varNames;
    }

    public String getIsAllowChangeSignaturePosition() {
        return isAllowChangeSignaturePosition;
    }

    public void setIsAllowChangeSignaturePosition(String isAllowChangeSignaturePosition) {
        this.isAllowChangeSignaturePosition = isAllowChangeSignaturePosition;
    }

    public String getReturnUrl() {
        return returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public String getVcodeMobile() {
        return vcodeMobile;
    }

    public void setVcodeMobile(String vcodeMobile) {
        this.vcodeMobile = vcodeMobile;
    }

    public String getIsDrawSignatureImage() {
        return isDrawSignatureImage;
    }

    public void setIsDrawSignatureImage(String isDrawSignatureImage) {
        this.isDrawSignatureImage = isDrawSignatureImage;
    }

    public String getSignatureImageName() {
        return signatureImageName;
    }

    public void setSignatureImageName(String signatureImageName) {
        this.signatureImageName = signatureImageName;
    }

    public String getPushUrl() {
        return pushUrl;
    }

    public void setPushUrl(String pushUrl) {
        this.pushUrl = pushUrl;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getIsShowHandwrittenTime() {
        return isShowHandwrittenTime;
    }

    public void setIsShowHandwrittenTime(String isShowHandwrittenTime) {
        this.isShowHandwrittenTime = isShowHandwrittenTime;
    }

    public String getIsFaceAuth() {
        return isFaceAuth;
    }

    public void setIsFaceAuth(String isFaceAuth) {
        this.isFaceAuth = isFaceAuth;
    }
}