package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;

import java.util.List;

/**
 * SDK引导常见问题
 */
@AdvancedFeignClient
public interface RemoteProblemMenusSdkService {

    /**
     * 查询所有问题类别
     */
    List<ProblemMenusPageDTO> listProblemCategory();

    /**
     * 分页查询常见问题列表
     */
    PageResultDto<ProblemMenusDto> listProblemMenusByType(ReqProblemMenusDto reqProblemMenusDto);

    /**
     * 查询配置菜单
     */
    List<ProblemMenusPageDTO> listProblemMenusConfig(Integer pageType, Integer pageSetupType);

    /**
     * 编辑配置菜单
     */
    Boolean editProblemMenusConfig(ProblemMenusPageDTO pageDTO);

    /**
     * 新增常见问题记录
     */
    Boolean saveProblemMenus(ProblemMenusDto problemMenusDto);

    /***
     * 更新常见问题记录
     */
    Boolean updateProblemMenus(ProblemMenusDto problemMenusDto);

    /***
     * 根据ID删除常见问题记录
     */
    Boolean removeProblemMenusById(Long id);

    /**
     * 查询对接引导常见问题
     */
    List<RspProblemMenus> listProblemMenus(Integer pageType, Integer pageSetupType);

    /**
     * 根据ID查询对接引导常见问题
     */
    ProblemMenusDto getProblemMenus(Long id);
}
