/**
 * Project Name:activity-center-common<br>
 * File Name:EntityUtil.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.common.util<br>
 * Date:2017年3月8日下午3:46:22<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.ssp.center.api.tool;


import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

/**
 * ClassName: EntityUtil <br/>
 * Function: 类工具. <br/>
 *
 * E:entity,dto之类的
 * I:id
 */
public class EntityUtil {

    private EntityUtil() {
    }


    /**
     * list转map
     * 支持过滤
     * @param list list
     * @param keyFunc 获取key的函数
     * @param <I> map的key。一般是id
     * @param <E> map的value，一般是 dto，entity
     * @return map
     */
    public static <I, E> Map<I, E> listToMap(List<E> list, Function<E, I> keyFunc) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<I, E> map = new HashMap<>();
        for (E e : list) {
            map.put(keyFunc.apply(e), e);
        }
        return map;

    }

    /**
     * list转map
     * 支持过滤
     * @param list list
     * @param keyFunc 获取key的函数
     * @param filterFunc 过滤函数，返回true表示过滤，返回的map中不包含被过滤的
     * @param <I> map的key。一般是id
     * @param <E> map的value，一般是 dto，entity
     * @return map
     */
    public static <I, E> Map<I, E> listToMap(List<E> list, Function<E, I> keyFunc, Predicate<E> filterFunc) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<I, E> map = new HashMap<>();
        for (E e : list) {
            if (!filterFunc.test(e)) {
                map.put(keyFunc.apply(e), e);
            }
        }
        return map;
    }


    /**
     * @Description: getParam 从List<Dto>中提取某个参数的list
     *
     * @Param: [list, t]
     * @Return: java.util.List<I>
     * @throws:
     */
    public static <I, E> List<I> getParam(List<E> list, Function<E, I> t) {

        List<I> result = new ArrayList<>();

        if (list == null || list.isEmpty()) {
            return result;
        }
        for (E e : list) {
            I k = t.apply(e);
            if (k != null) {
                result.add(k);
            }
        }
        return result;
    }


    /**
     * list转map
     * @param list list
     * @param keyFunc 获取key的函数
     * @param valFunc 获取val的函数
     * @param <I> map的key。一般是id
     * @param <T> map的value string....
     * @param <E> 一般是 dto，entity
     * @return map
     */
    public static <I,T,E> Map<I, T> listToMap(List<E> list,Function<E, I> keyFunc, Function<E, T> valFunc) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<I, T> map = new HashMap<>();
        for (E e : list) {
            map.put(keyFunc.apply(e), valFunc.apply(e));
        }
        return map;
    }

}
