/**
 * Project Name:ssp-center-api File Name:SensitiveUtil.java Package Name:cn.com.duiba.tuia.ssp.center.api.annotation
 * Date:2017年10月26日下午3:45:41 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.annotation;

import java.lang.reflect.Field;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import com.google.common.collect.Lists;

/**
 * ClassName:SensitiveUtil <br/>
 * Function: 敏感字段脱敏工具类 <br/>
 * Date: 2017年10月26日 下午3:45:41 <br/>
 * 
 * @author Administrator
 * @version
 * @since JDK 1.6
 * @see
 */
public class SensitiveUtil {

    private SensitiveUtil() {
    }

    public static <T> void sensitive(T o) {
        try {
            if (o == null) {
                return;
            }
            List<Field> fileds = findAllField(o.getClass());
            if (CollectionUtils.isEmpty(fileds)) {
                return;
            }
            for (Field field : fileds) {
                if (field.isAnnotationPresent(SensitiveInfo.class) && field.getType() == String.class) {
                    field.setAccessible(true);
                    SensitiveInfo sensitiveInfo = field.getAnnotation(SensitiveInfo.class);
                    String value = (String) field.get(o);
                    SensitiveType type = sensitiveInfo.sensitiveType();
                    //appName 特殊处理
                    if (SensitiveType.APP_NAME.equals(type)) {
                        continue;
                    }
                    field.set(o, sensitiveStr(value, type));

                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T> void sensitiveAppName(T o) {
        try {
            Field[] declaredFields = o.getClass().getDeclaredFields();
            for (Field declaredField : declaredFields) {
                if (declaredField.isAnnotationPresent(SensitiveInfo.class)){
                    SensitiveInfo annotation = declaredField.getAnnotation(SensitiveInfo.class);
                    SensitiveType sensitiveType = annotation.sensitiveType();
                    if (SensitiveType.APP_NAME.equals(sensitiveType)){
                        declaredField.setAccessible(true);
                        String value = (String) declaredField.get(o);
                        declaredField.set(o, sensitiveStr(value, sensitiveType));
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T> void sensitive(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(SensitiveUtil::sensitive);
    }

    private static List<Field> findAllField(Class<?> clazz) {
        List<Field> fileds = Lists.newArrayList();
        SensitiveInfo sensitiveInfo = clazz.getAnnotation(SensitiveInfo.class);
        if (null != sensitiveInfo && sensitiveInfo.sensitiveFields() != null) {
            String[] fieldNames = sensitiveInfo.sensitiveFields();
            for (String name : fieldNames) {
                fileds.add(findField(clazz, name));
            }
        }
        return fileds;
    }

    private static Field findField(Class<?> clazz, String name) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(name);
        } catch (NoSuchFieldException e) {

        }
        while (clazz != Object.class) {
            Class<?> supClazz = clazz.getSuperclass();
            if (null != supClazz) {
                try {
                    field = supClazz.getDeclaredField(name);
                } catch (NoSuchFieldException e) {
                }
                clazz = supClazz;
            }
        }
        return field;
    }

    public static String sensitiveStr(String concent, SensitiveType type) {
        switch (type) {
            case USERNAME:
                return sensitive4uname(concent);
            case EMAIL:
                return sensitive4email(concent);
            case MOBILE:
                return sensitive4mobile(concent);
            case APP_NAME:
                return "***";
            default:
                return "";
        }
    }

    private static String sensitive4uname(String concent) {
        if (StringUtils.isNoneBlank(concent)) {
            String first = StringUtils.left(concent, 1);
            return StringUtils.replace(concent, first, "*", 1);
        }
        return "";
    }

    private static String sensitive4mobile(String concent) {
        if (StringUtils.isNoneBlank(concent)) {
            String head = StringUtils.left(concent, 3);
            String foot = StringUtils.right(concent, 4);
            return head + "****" + foot;
        }
        return "";
    }

    private static String sensitive4email(String concent) {
        if (StringUtils.isNoneBlank(concent)) {
            String head = StringUtils.substring(concent, 0, StringUtils.indexOf(concent, "@"));
            return StringUtils.replace(concent, head, "****", 1);
        }
        return "";
    }
}
