/**
 * Project Name:media-manager-biz File Name:ReqMaterialStatis.java Package
 * Name:cn.com.duiba.tuia.media.manager.model.req Date:2017年3月14日下午4:04:27 Copyright (c) 2017, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.util.List;

import io.swagger.annotations.ApiModelProperty;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:ReqMaterialStatis <br/>
 * Function: 素材统计查询. <br/>
 * Date: 2017年3月14日 下午4:04:27 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class ReqMaterialStatistics extends ReqMaterialStatisticsBase {

    /** 序列号 */
    private static final long serialVersionUID = 2602776111753942620L;

    /** 素材名称 */
    @ApiModelProperty(value = "素材名称", required = false)
    private String            materialName;

    /** 活动名称 */
    @ApiModelProperty(value = "活动名称", required = false)
    private String            activityName;

    /** 广告位名称 */
    @ApiModelProperty(value = "广告位名称", required = false)
    private String            slotName;

    /** 广告位规格名称 */
    @ApiModelProperty(value = "广告位规格名称", required = false)
    private String            msName;

    /** 广告位规格IDS */
    @ApiModelProperty(value = "广告位规格IDS", required = false)
    private List<Long>        msIds;

    /** 活动IDS */
    @ApiModelProperty(value = "活动IDS", required = false)
    private List<Long>        activityIds;
    
    /** 素材库IDS */
    @ApiModelProperty(value = "素材库IDS", required = false)
    private List<Long>        sckIds;
    
    /** 媒体ID */
    @ApiModelProperty(value = "媒体ID", required = false)
    private Long              appId;
    
	/**
     *  0-不排序
     *  1-正序
     *  2-倒序
     */
    @ApiModelProperty(value = "曝光PV排序类型", required = false)
    private int sortExpose;

    /**
     *  0-不排序
     *  1-正序
     *  2-倒序
     */
    @ApiModelProperty(value = "点击PV排序类型", required = false)
    private int sortClick;

    /**
     *  0-不排序
     *  1-正序
     *  2-倒序
     */
    @ApiModelProperty(value = "点击率排序类型",  required = false)
    private int sortClickRate;

    /**
     * Gets the activityName.
     *
     * @return the activityName
     */
    public String getActivityName() {
        return activityName;
    }

    /**
     * Sets the activityName.
     *
     * @param activityName the activityName
     */
    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public String getMaterialName() {
		return materialName;
	}

	public void setMaterialName(String materialName) {
		this.materialName = materialName;
	}

	public String getSlotName() {
		return slotName;
	}

	public void setSlotName(String slotName) {
		this.slotName = slotName;
	}

	/**
     * Gets the msName.
     *
     * @return the msName
     */
    public String getMsName() {
        return msName;
    }

    /**
     * Sets the msName.
     *
     * @param msName the msName
     */
    public void setMsName(String msName) {
        this.msName = msName;
    }

    /**
     * Gets the msIds.
     *
     * @return the msIds
     */
    public List<Long> getMsIds() {
        return msIds;
    }

    /**
     * Sets the msIds.
     *
     * @param msIds the msIds
     */
    public void setMsIds(List<Long> msIds) {
        this.msIds = msIds;
    }

    /**
     * Gets the activityIds.
     *
     * @return the activityIds
     */
    public List<Long> getActivityIds() {
        return activityIds;
    }

    /**
     * Sets the activityIds.
     *
     * @param activityIds the activityIds
     */
    public void setActivityIds(List<Long> activityIds) {
        this.activityIds = activityIds;
    }

    public List<Long> getSckIds() {
		return sckIds;
	}

	public void setSckIds(List<Long> sckIds) {
		this.sckIds = sckIds;
	}

	/**
     * Gets the sortExpose.
     *
     * @return the sortExpose
     */
    public int getSortExpose() { return sortExpose; }

    /**
     * Sets the sortExpose.
     *
     * @param sortExpose the sortExpose
     */
    public void setSortExpose(int sortExpose) { this.sortExpose = sortExpose; }

    /**
     * Gets the sortClick.
     *
     * @return the sortClick
     */
    public int getSortClick() { return sortClick; }

    /**
     * Sets the sortClick.
     *
     * @param sortClick the sortClick
     */
    public void setSortClick(int sortClick) { this.sortClick = sortClick; }

    /**
     * Gets the sortClickRate.
     *
     * @return the sortClickRate
     */
    public int getSortClickRate() { return sortClickRate; }

    /**
     * Sets the sortClickRate.
     *
     * @param sortClickRate the sortClickRate
     */
    public void setSortClickRate(int sortClickRate) { this.sortClickRate = sortClickRate; }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}
}
