/**
 * 文件名： Result.java 此类描述的是： 作者: leiliang 创建时间: 2016年3月23日 上午11:00:27
 */
package cn.com.duiba.tuia.ssp.center.api.dto;

import cn.com.duiba.tuia.ssp.center.api.constant.SSPErrorCode;
import lombok.Data;

import java.io.Serializable;

/**
 * <一句话功能描述> <功能详细描述>.
 *
 * @param <T> the generic type
 * @author: leiliang
 * @version:
 */
@Data
public class Result<T> implements Serializable {

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = -1467576157657126613L;

    /** The t. */
    private T                 data;

    /** The code. */
    private String            code;

    /** The message. */
    private String            desc;

    public static <T> Result<T> success(T data){
        Result<T> result = new Result<>();
        result.setData(data);
        result.setCode(SSPErrorCode.SSP_000000.getCode());
        result.setDesc(SSPErrorCode.SSP_000000.getDesc());
        return result;
    }

    public static <T> Result<T> error(String code, String desc){
        Result<T> result = new Result<>();
        result.setCode(code);
        result.setDesc(desc);
        return result;
    }

    public static <T> Result<T> error(SSPErrorCode errorCode){
        Result<T> result = new Result<>();
        result.setCode(errorCode.getCode());
        result.setDesc(errorCode.getDesc());
        return result;
    }

    public boolean isSuccess(){
        return SSPErrorCode.SSP_000000.getCode().equals(code);
    }

}
