/**
 * Project Name:media-biz File Name:UpdateMediaReq.java Package Name:cn.com.duiba.tuia.media.model
 * Date:2016年9月26日下午3:33:12 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * ClassName:ReqUpdateMediaApp <br/>
 * Date: 2016年9月26日 下午3:33:12 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class ReqUpdateMediaApp implements Serializable {

    /** 序列号 */
    private static final long  serialVersionUID     = 5793038848276258068L;

    /** 开通状态:3-风控待审核. */
    public static final int    MEDIA_APP_CHECKING   = 3;
    /** 开通状态:1-审核通过. */
    public static final int    MEDIA_APP_CHECK_PASS = 1;
    /** 开通状态:2-审核拒绝. */
    public static final int    MEDIA_APP_CHECK_FAIL = 2;

    /** 平台类型 1 Android */
    public static final String PLATFORM_TYE_ANDROID = "1";
    /** 平台类型 2 IOS */
    public static final String PLATFORM_TYE_IOS     = "2";

    /** 平台类型-Android */
    public static final String PLATFORM_ANDROID     = "Android";
    /** 平台类型-IOS */
    public static final String PLATFORM_IOS         = "IOS";

    /** 媒体id. */
    @ApiModelProperty(value = "媒体id", required = true)
    private Long               appId;

    /** 媒体名称. */
    @ApiModelProperty(value = "媒体名称", required = true)
    @Size(min = 2, max = 20, message = "媒体名称最大不能超过20个字符")
    private String             appName;

    /** 行业. */
    @ApiModelProperty(value = "行业类型", required = true)
    private String             industry;

    /** 系统平台. */
    @ApiModelProperty(value = "系统平台", required = true)
    private String             platform;

    /** 开通状态:0-待审核;1-审核通过;2-审核拒绝. */
    @ApiModelProperty(value = "审核状态", required = true)
    private Integer            checkStatus;
    
    /** 验证状态:0-待验证;1-验证通过 */
    @ApiModelProperty(value = "验证状态", required = true)
    private Integer            verifyStatus;

    /** 程序主包名. */
    @ApiModelProperty(value = "程序主包名", required = false)
    private String             appPackage;

    /** 媒体关键词. */
    @ApiModelProperty(value = "媒体关键词", required = false)
    @Size(max = 20, message = "媒体关键词最大不能超过20个字符")
    private String             appKeyWords;

    /** 媒体简介. */
    @ApiModelProperty(value = "媒体简介", required = false)
    @Size(max = 100, message = "最大不能超过100个字符!")
    private String             description;

    /** 下载地址. */
    @ApiModelProperty(value = "下载地址", required = false)
    private String             downloadUrl;

    /** 媒体账号ID */
    @ApiModelProperty(value = "媒体账号ID", required = false)
    private Long               mediaId;
    
    /** 公众账号名称 */
    @ApiModelProperty(value = "公众账号名称", required = false)
    private String             officialAccountName;
    
    /**公众号类别：0:订阅号，1：服务号*/
    @ApiModelProperty(value = "公众号类别", required = false)
    private Integer            officialAccountType;
    
    /**公众号主体，0:企业，1:个人*/
    @ApiModelProperty(value = "公众号主体", required = false)
    private Integer            officialAccountSubject;

    /**媒体标签(广告那边的一级标签)*/
    @ApiModelProperty(value = "媒体标签(广告那边的一级标签)", required = false)
    private String             appTagNum;

    /**媒体是否支持下载类广告:0:不支持，1:支持*/
    @ApiModelProperty(value = "体是否支持下载类广告", required = false)
    private Integer            downloadAdvert;

    @ApiModelProperty(value = "拒绝原因", required = false)
    private String refuseMsg;

    @ApiModelProperty(value = "保存状态 0-提交 1-暂存", required = true)
    @NotNull(message = "保存状态不能为空")
    private Integer   saveStatus;

    private String   createDate;

    /**
     * 行业标签ID（大类ID组别ID标签ID之间用-分割，如“5-21-249”）
     */
    private String industryTagId;

    @ApiModelProperty(value = "标签审核状态（0：未审核 1：已审核）")
    private Integer tagCheckStatus;

    private Integer tempCheckStatus;

    public String getIndustryTagId() {
        return industryTagId;
    }

    public void setIndustryTagId(String industryTagId) {
        this.industryTagId = industryTagId;
    }

    public String getCreateDate() {
        return createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }
    public Integer getDownloadAdvert() {
        return downloadAdvert;
    }

    public void setDownloadAdvert(Integer downloadAdvert) {
        this.downloadAdvert = downloadAdvert;
    }

    /**
     * mediaId.
     *
     * @return the mediaId
     * @since JDK 1.6
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * mediaId.
     *
     * @param mediaId the mediaId to set
     * @since JDK 1.6
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getIndustry() {
        return industry;
    }

    public void setIndustry(String industry) {
        this.industry = industry;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getAppPackage() {
        return appPackage;
    }

    public void setAppPackage(String appPackage) {
        this.appPackage = appPackage;
    }

    public String getAppKeyWords() {
        return appKeyWords;
    }

    public void setAppKeyWords(String appKeyWords) {
        this.appKeyWords = appKeyWords;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDownloadUrl() {
        return downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }
   
	public Integer getVerifyStatus() {
		return verifyStatus;
	}

	public void setVerifyStatus(Integer verifyStatus) {
		this.verifyStatus = verifyStatus;
	}

    public String getOfficialAccountName() {
        return officialAccountName;
    }

    public void setOfficialAccountName(String officialAccountName) {
        this.officialAccountName = officialAccountName;
    }

    public Integer getOfficialAccountType() {
        return officialAccountType;
    }

    public void setOfficialAccountType(Integer officialAccountType) {
        this.officialAccountType = officialAccountType;
    }

    public Integer getOfficialAccountSubject() {
        return officialAccountSubject;
    }

    public void setOfficialAccountSubject(Integer officialAccountSubject) {
        this.officialAccountSubject = officialAccountSubject;
    }

    public String getAppTagNum() {
        return appTagNum;
    }

    public void setAppTagNum(String appTagNum) {
        this.appTagNum = appTagNum;
    }

    public String getRefuseMsg() {
        return refuseMsg;
    }

    public void setRefuseMsg(String refuseMsg) {
        this.refuseMsg = refuseMsg;
    }

    public Integer getSaveStatus() {
        return saveStatus;
    }

    public void setSaveStatus(Integer saveStatus) {
        this.saveStatus = saveStatus;
    }

    public Integer getTagCheckStatus() {
        return tagCheckStatus;
    }

    public void setTagCheckStatus(Integer tagCheckStatus) {
        this.tagCheckStatus = tagCheckStatus;
    }

    public Integer getTempCheckStatus() {
        return tempCheckStatus;
    }

    public void setTempCheckStatus(Integer tempCheckStatus) {
        this.tempCheckStatus = tempCheckStatus;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
