package cn.com.duiba.tuia.ssp.center.api.remote.ocpx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ProgrammaticMediaReportHisRspDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.ProgrammaticMediaReportRspDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.ProgrammaticMediaReportStrategyDTO;
import cn.com.duiba.tuia.ssp.center.api.params.ProgrammaticMediaReportCopyReq;
import cn.com.duiba.tuia.ssp.center.api.params.ProgrammaticMediaReportQuery;
import cn.com.duiba.tuia.ssp.center.api.params.ProgrammaticMediaReportReq;

import java.util.List;

/**
 * @Author yuquanfeng
 * @Date 2022/4/8
 * @Description
 * @Param
 * @return
 **/
@AdvancedFeignClient
public interface RemoteProgrammaticMediaReportService {
    /**
     * 添加策略
     * @param req
     * @return
     */
    Boolean addReportStrategy(ProgrammaticMediaReportReq req);

    /**
     * 编辑策略
     * @param req
     * @return
     */
    Boolean editReportStrategy(ProgrammaticMediaReportReq req);

    /**
     * 复制上报策略
     * @param req
     * @return
     */
    Boolean copyReportStrategy(ProgrammaticMediaReportCopyReq req);

    /**
     * 查询策略列表
     * @param param
     * @return
     */
    PageResultDto<ProgrammaticMediaReportStrategyDTO> listReportStrategy(ProgrammaticMediaReportQuery param);

    /**
     * 查询策略详情
     * @param id
     * @return
     */
    ProgrammaticMediaReportRspDTO queryReportStrategyDetail(Long id);

    /**
     * 查询修改记录
     * @param id
     * @return
     */
    ProgrammaticMediaReportHisRspDTO history(Long id);

    /**
     * 通过广告位id查询上报策略
     * @param slotId 广告位id
     * @return
     */
    ProgrammaticMediaReportStrategyDTO queryStrategyBySlotId(Long slotId);

    /**
     * 通过广告位id查询配置
     * 这个接口是提供给activity-web 用的
     * @param slotId 广告位id
     * @return
     */
    ProgrammaticMediaReportRspDTO queryDetailBySlotId(Long slotId);

    /**
     * 删除上报策略
     * @param id 上报策略id
     * @return
     */
    Boolean delete(Long id);
}
