/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.constant;

import java.util.Arrays;
import java.util.Objects;

public enum SpecificationTemplateTypeEnum {
    CUSTOM(0, "", "\u81ea\u5b9a\u4e49"),
    BOTTOM_PIC(1, "700*280", "\u4e0a\u6587\u4e0b\u56fe"),
    RIGHT_PIC(2, "225*140", "\u5de6\u6587\u53f3\u56fe"),
    LEFT_PIC(3, "225*140", "\u5de6\u56fe\u53f3\u6587"),
    THREE_PIC(4, "228*150", "\u4e09\u56fe");

    private Integer type;
    private String spec;
    private String name;

    private SpecificationTemplateTypeEnum(Integer type, String spec, String name) {
        this.type = type;
        this.name = name;
        this.spec = spec;
    }

    public Integer getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getSpec() {
        return this.spec;
    }

    public static String getNameByType(Integer type) {
        return Arrays.stream(SpecificationTemplateTypeEnum.values()).filter(v -> Objects.equals(v.getType(), type)).map(SpecificationTemplateTypeEnum::getName).findFirst().orElse("");
    }

    public static String getTemplateTypeMsName(Integer sckType, String sceneDesc, String spec) {
        return SpecificationTemplateTypeEnum.getTemplateTypeMsName(sckType, sceneDesc, spec, null, null, null);
    }

    public static String getTemplateTypeMsName(Integer sckType, String sceneDesc, String spec, Integer templateType, Integer imageWidth, Integer imageHeight) {
        if (Objects.equals(sckType, 6)) {
            return sceneDesc;
        }
        if (Objects.isNull(sckType) || Objects.isNull(templateType) || Objects.equals(templateType, 0)) {
            if (Objects.equals(imageWidth, 225) && Objects.equals(imageHeight, 140)) {
                return sceneDesc + "(" + RIGHT_PIC.getName() + ":" + spec + ")";
            }
            if (Objects.equals(imageWidth, 700) && Objects.equals(imageHeight, 280)) {
                return sceneDesc + "(" + BOTTOM_PIC.getName() + ":" + spec + ")";
            }
            return sceneDesc + "(" + CUSTOM.getName() + ":" + spec + ")";
        }
        String desc = SpecificationTemplateTypeEnum.getNameByType(templateType);
        return sceneDesc + "(" + desc + ":" + spec + ")";
    }
}

