package cn.com.duiba.tuia.ssp.center.api.dto.finaceData;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 媒体账户日报对象 tb_account_report_day_merge
 * 
 * @author liuyajun
 * @date 2022-02-11
 */
public class AccountReportDayMergeDTO implements Serializable {
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 媒体用户id */
    private Long mediaId;

    /** 应用id */
    private Long appId;

    /** 广告位id */
    private Long slotId;

    /** 每日发券量 */
    private Long launchCount;

    /** 每日曝光数 */
    private Long exposureCount;

    /** 每日点击数 */
    private Long clickCount;

    /** 每日点击人数 */
    private Long clickCountUv;

    /** 每日消费(分) */
    private Long consumeTotal;

    /** 有效点击数 */
    private Long efClickCount;

    /** 当天日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date curDate;

    /** 记录创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date gmtCreate;

    /** 记录修改时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date gmtModified;

    /** 每日广告消耗(分) */
    private Long adConsume;

    /** 每日媒体预计分成(分） */
    private Long exConsumeTotal;

    /** 入口曝光量 */
    private Long actExposeCount;

    /** 入口点击量 */
    private Long actClickCount;

    /** 广告位访问UV */
    private Long sdkUv;

    /** 活动广告券请求 */
    private Long advertRequestCount;

    /** 媒体预计分成按分存储 */
    private Long mediaExDivide;

    /** 媒体应得分成按分存储 */
    private Long mediaDueDivide;

    /** 活动请求uv */
    private Long actRequestUv;

    /** 杭州每日广告消耗(分) */
    private Long hzAdConsume;

    /** 霍尔果斯每日广告消耗(分) */
    private Long hegsAdConsume;

    /** 杭州每日媒体预计分成(分） */
    private Long hzExConsumeTotal;

    /** 霍尔果斯每日媒体预计分成(分） */
    private Long hegsExConsumeTotal;

    /** 杭州每日消费(分) */
    private Long hzConsumeTotal;

    /** 霍尔果斯每日消费(分) */
    private Long hegsConsumeTotal;

    /** 杭州媒体预计分成按分存储 */
    private Long hzMediaExDivide;

    /** 霍尔果斯媒体预计分成按分存储 */
    private Long hegsMediaExDivide;

    /** 杭州媒体应得分成按分存储 */
    private Long hzMediaDueDivide;

    /** 霍尔果斯媒体应得分成按分存储 */
    private Long hegsMediaDueDivide;

    /** 是否已结算0未结算 1已结算 */
    private Integer settled;

    /** 现金消耗(分) */
    private BigDecimal cashConsume;

    /** 杭州现金消耗(分) */
    private BigDecimal hzCashConsume;

    /** 霍尔果斯现金消耗(分) */
    private BigDecimal hegsCashConsume;

    /** 霍城兑捷每日广告消耗(分) */
    private Long hcdjAdConsume;

    /** 霍城兑捷每日媒体预计分成(分） */
    private Long hcdjExConsumeTotal;

    /** 霍城兑捷每日消费(分) */
    private Long hcdjConsumeTotal;

    /** 霍城兑捷州媒体预计分成按分存储 */
    private Long hcdjMediaExDivide;

    /** 霍城兑捷媒体应得分成按分存储 */
    private Long hcdjMediaDueDivide;

    /** 霍城兑捷现金消耗(分) */
    private BigDecimal hcdjCashConsume;

    /** 兑推每日广告消耗(分) */
    private Long duituiAdConsume;

    /** 兑推每日媒体预计分成(分） */
    private Long duituiExConsumeTotal;

    /** 兑推每日消费(分) */
    private Long duituiConsumeTotal;

    /** 兑推媒体预计分成按分存储 */
    private Long duituiMediaExDivide;

    /** 兑推媒体应得分成按分存储 */
    private Long duituiMediaDueDivide;

    /** 兑推现金消耗(分) */
    private BigDecimal duituiCashConsume;

    /**
     * 原有广告消耗（分）
     */
    private Long adConsumeOriginal;

    /**
     * 原有现金消耗(分)
     */
    private Long cashConsumeOriginal;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setMediaId(Long mediaId) 
    {
        this.mediaId = mediaId;
    }

    public Long getMediaId() 
    {
        return mediaId;
    }
    public void setAppId(Long appId) 
    {
        this.appId = appId;
    }

    public Long getAppId() 
    {
        return appId;
    }
    public void setSlotId(Long slotId) 
    {
        this.slotId = slotId;
    }

    public Long getSlotId() 
    {
        return slotId;
    }
    public void setLaunchCount(Long launchCount) 
    {
        this.launchCount = launchCount;
    }

    public Long getLaunchCount() 
    {
        return launchCount;
    }
    public void setExposureCount(Long exposureCount) 
    {
        this.exposureCount = exposureCount;
    }

    public Long getExposureCount() 
    {
        return exposureCount;
    }
    public void setClickCount(Long clickCount) 
    {
        this.clickCount = clickCount;
    }

    public Long getClickCount() 
    {
        return clickCount;
    }
    public void setClickCountUv(Long clickCountUv) 
    {
        this.clickCountUv = clickCountUv;
    }

    public Long getClickCountUv() 
    {
        return clickCountUv;
    }
    public void setConsumeTotal(Long consumeTotal) 
    {
        this.consumeTotal = consumeTotal;
    }

    public Long getConsumeTotal() 
    {
        return consumeTotal;
    }
    public void setEfClickCount(Long efClickCount) 
    {
        this.efClickCount = efClickCount;
    }

    public Long getEfClickCount() 
    {
        return efClickCount;
    }
    public void setCurDate(Date curDate) 
    {
        this.curDate = curDate;
    }

    public Date getCurDate() 
    {
        return curDate;
    }
    public void setGmtCreate(Date gmtCreate) 
    {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() 
    {
        return gmtCreate;
    }
    public void setGmtModified(Date gmtModified) 
    {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() 
    {
        return gmtModified;
    }
    public void setAdConsume(Long adConsume) 
    {
        this.adConsume = adConsume;
    }

    public Long getAdConsume() 
    {
        return adConsume;
    }
    public void setExConsumeTotal(Long exConsumeTotal) 
    {
        this.exConsumeTotal = exConsumeTotal;
    }

    public Long getExConsumeTotal() 
    {
        return exConsumeTotal;
    }
    public void setActExposeCount(Long actExposeCount) 
    {
        this.actExposeCount = actExposeCount;
    }

    public Long getActExposeCount() 
    {
        return actExposeCount;
    }
    public void setActClickCount(Long actClickCount) 
    {
        this.actClickCount = actClickCount;
    }

    public Long getActClickCount() 
    {
        return actClickCount;
    }
    public void setSdkUv(Long sdkUv) 
    {
        this.sdkUv = sdkUv;
    }

    public Long getSdkUv() 
    {
        return sdkUv;
    }
    public void setAdvertRequestCount(Long advertRequestCount) 
    {
        this.advertRequestCount = advertRequestCount;
    }

    public Long getAdvertRequestCount() 
    {
        return advertRequestCount;
    }
    public void setMediaExDivide(Long mediaExDivide) 
    {
        this.mediaExDivide = mediaExDivide;
    }

    public Long getMediaExDivide() 
    {
        return mediaExDivide;
    }
    public void setMediaDueDivide(Long mediaDueDivide) 
    {
        this.mediaDueDivide = mediaDueDivide;
    }

    public Long getMediaDueDivide() 
    {
        return mediaDueDivide;
    }
    public void setActRequestUv(Long actRequestUv) 
    {
        this.actRequestUv = actRequestUv;
    }

    public Long getActRequestUv() 
    {
        return actRequestUv;
    }
    public void setHzAdConsume(Long hzAdConsume) 
    {
        this.hzAdConsume = hzAdConsume;
    }

    public Long getHzAdConsume() 
    {
        return hzAdConsume;
    }
    public void setHegsAdConsume(Long hegsAdConsume) 
    {
        this.hegsAdConsume = hegsAdConsume;
    }

    public Long getHegsAdConsume() 
    {
        return hegsAdConsume;
    }
    public void setHzExConsumeTotal(Long hzExConsumeTotal) 
    {
        this.hzExConsumeTotal = hzExConsumeTotal;
    }

    public Long getHzExConsumeTotal() 
    {
        return hzExConsumeTotal;
    }
    public void setHegsExConsumeTotal(Long hegsExConsumeTotal) 
    {
        this.hegsExConsumeTotal = hegsExConsumeTotal;
    }

    public Long getHegsExConsumeTotal() 
    {
        return hegsExConsumeTotal;
    }
    public void setHzConsumeTotal(Long hzConsumeTotal) 
    {
        this.hzConsumeTotal = hzConsumeTotal;
    }

    public Long getHzConsumeTotal() 
    {
        return hzConsumeTotal;
    }
    public void setHegsConsumeTotal(Long hegsConsumeTotal) 
    {
        this.hegsConsumeTotal = hegsConsumeTotal;
    }

    public Long getHegsConsumeTotal() 
    {
        return hegsConsumeTotal;
    }
    public void setHzMediaExDivide(Long hzMediaExDivide) 
    {
        this.hzMediaExDivide = hzMediaExDivide;
    }

    public Long getHzMediaExDivide() 
    {
        return hzMediaExDivide;
    }
    public void setHegsMediaExDivide(Long hegsMediaExDivide) 
    {
        this.hegsMediaExDivide = hegsMediaExDivide;
    }

    public Long getHegsMediaExDivide() 
    {
        return hegsMediaExDivide;
    }
    public void setHzMediaDueDivide(Long hzMediaDueDivide) 
    {
        this.hzMediaDueDivide = hzMediaDueDivide;
    }

    public Long getHzMediaDueDivide() 
    {
        return hzMediaDueDivide;
    }
    public void setHegsMediaDueDivide(Long hegsMediaDueDivide) 
    {
        this.hegsMediaDueDivide = hegsMediaDueDivide;
    }

    public Long getHegsMediaDueDivide() 
    {
        return hegsMediaDueDivide;
    }
    public void setSettled(Integer settled) 
    {
        this.settled = settled;
    }

    public Integer getSettled() 
    {
        return settled;
    }
    public void setCashConsume(BigDecimal cashConsume) 
    {
        this.cashConsume = cashConsume;
    }

    public BigDecimal getCashConsume() 
    {
        return cashConsume;
    }
    public void setHzCashConsume(BigDecimal hzCashConsume) 
    {
        this.hzCashConsume = hzCashConsume;
    }

    public BigDecimal getHzCashConsume() 
    {
        return hzCashConsume;
    }
    public void setHegsCashConsume(BigDecimal hegsCashConsume) 
    {
        this.hegsCashConsume = hegsCashConsume;
    }

    public BigDecimal getHegsCashConsume() 
    {
        return hegsCashConsume;
    }
    public void setHcdjAdConsume(Long hcdjAdConsume) 
    {
        this.hcdjAdConsume = hcdjAdConsume;
    }

    public Long getHcdjAdConsume() 
    {
        return hcdjAdConsume;
    }
    public void setHcdjExConsumeTotal(Long hcdjExConsumeTotal) 
    {
        this.hcdjExConsumeTotal = hcdjExConsumeTotal;
    }

    public Long getHcdjExConsumeTotal() 
    {
        return hcdjExConsumeTotal;
    }
    public void setHcdjConsumeTotal(Long hcdjConsumeTotal) 
    {
        this.hcdjConsumeTotal = hcdjConsumeTotal;
    }

    public Long getHcdjConsumeTotal() 
    {
        return hcdjConsumeTotal;
    }
    public void setHcdjMediaExDivide(Long hcdjMediaExDivide) 
    {
        this.hcdjMediaExDivide = hcdjMediaExDivide;
    }

    public Long getHcdjMediaExDivide() 
    {
        return hcdjMediaExDivide;
    }
    public void setHcdjMediaDueDivide(Long hcdjMediaDueDivide) 
    {
        this.hcdjMediaDueDivide = hcdjMediaDueDivide;
    }

    public Long getHcdjMediaDueDivide() 
    {
        return hcdjMediaDueDivide;
    }
    public void setHcdjCashConsume(BigDecimal hcdjCashConsume) 
    {
        this.hcdjCashConsume = hcdjCashConsume;
    }

    public BigDecimal getHcdjCashConsume() 
    {
        return hcdjCashConsume;
    }

    public Long getDuituiAdConsume() {
        return duituiAdConsume;
    }

    public void setDuituiAdConsume(Long duituiAdConsume) {
        this.duituiAdConsume = duituiAdConsume;
    }

    public Long getDuituiExConsumeTotal() {
        return duituiExConsumeTotal;
    }

    public void setDuituiExConsumeTotal(Long duituiExConsumeTotal) {
        this.duituiExConsumeTotal = duituiExConsumeTotal;
    }

    public Long getDuituiConsumeTotal() {
        return duituiConsumeTotal;
    }

    public void setDuituiConsumeTotal(Long duituiConsumeTotal) {
        this.duituiConsumeTotal = duituiConsumeTotal;
    }

    public Long getDuituiMediaExDivide() {
        return duituiMediaExDivide;
    }

    public void setDuituiMediaExDivide(Long duituiMediaExDivide) {
        this.duituiMediaExDivide = duituiMediaExDivide;
    }

    public Long getDuituiMediaDueDivide() {
        return duituiMediaDueDivide;
    }

    public void setDuituiMediaDueDivide(Long duituiMediaDueDivide) {
        this.duituiMediaDueDivide = duituiMediaDueDivide;
    }

    public BigDecimal getDuituiCashConsume() {
        return duituiCashConsume;
    }

    public void setDuituiCashConsume(BigDecimal duituiCashConsume) {
        this.duituiCashConsume = duituiCashConsume;
    }

    public Long getAdConsumeOriginal() {
        return adConsumeOriginal;
    }

    public void setAdConsumeOriginal(Long adConsumeOriginal) {
        this.adConsumeOriginal = adConsumeOriginal;
    }

    public Long getCashConsumeOriginal() {
        return cashConsumeOriginal;
    }

    public void setCashConsumeOriginal(Long cashConsumeOriginal) {
        this.cashConsumeOriginal = cashConsumeOriginal;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
